export function GenerateUrlGoogle(
  titulo,
  descripcion,
  fecha,
  horaInicio,
  horaFin,
  direccion
) {
  const apiKey = process.env.NEXT_PUBLIC_GOOGLE_MAPS_API_KEY;

  const location = direccion ? encodeURIComponent(direccion) : "";
  const mapsURL = location ? `https://www.google.com/maps?q=${location}` : "";
  const embedMapsUrl =
    location !== ""
      ? `https://www.google.com/maps/embed/v1/place?q=${location}&key=${apiKey}&maptype=satellite&zoom=18`
      : "";

  const horaInicioDef = horaInicio || "00:00";
  const horaFinDef = horaFin || "23:59";

  const [day, month, year] = fecha.split("/");
  const [hourStart, minuteStart] = horaInicioDef.split(":");
  const [hourEnd, minuteEnd] = horaFinDef.split(":");

  const start = new Date(year, month - 1, day, hourStart, minuteStart);
  const end = new Date(year, month - 1, day, hourEnd, minuteEnd);

  const formatDate = (date) =>
    date.getFullYear().toString() +
    pad(date.getMonth() + 1) +
    pad(date.getDate()) +
    "T" +
    pad(date.getHours()) +
    pad(date.getMinutes()) +
    pad(date.getSeconds());

  const encodedTitle = encodeURIComponent(titulo);
  const encodedDetails = encodeURIComponent(descripcion);

  const calendarURL = `https://www.google.com/calendar/render?action=TEMPLATE&text=${encodedTitle}&dates=${formatDate(
    start
  )}/${formatDate(end)}&details=${encodedDetails}&location=${location}`;

  return {
    calendarURL,
    mapsURL,
    embedMapsUrl,
  };
}

function pad(n) {
  return n.toString().padStart(2, "0");
}
