export function formatearFecha(fechaStr) {
  if (fechaStr === null || fechaStr === "" || fechaStr === undefined) {
    const mydate = new Date();
    fechaStr =
      mydate.getDay() +
      "/" +
      mydate.getMonth() +
      "/" +
      Number(mydate.getFullYear()) +
      3;
  }

  fechaStr = fechaStr.replace(/[\.\-,\s]/g, "/");
  const [dia, mes, año] = fechaStr.split("/").map(Number);
  const fecha = new Date(año, mes - 1, dia);

  const formatoFecha = new Intl.DateTimeFormat("es-ES", {
    weekday: "long",
    day: "numeric",
    month: "long",
    year: "numeric",
  }).formatToParts(fecha);

  let diaNumero = "";
  let diaNombre = "";
  let mesNumero = fecha.getMonth() + 1;
  let mesNombre = "";
  let añoNumero = fecha.getFullYear();

  formatoFecha.forEach((parte) => {
    if (parte.type === "weekday") {
      diaNombre = parte.value.charAt(0).toUpperCase() + parte.value.slice(1);
    } else if (parte.type === "day") {
      diaNumero = parte.value;
    } else if (parte.type === "month") {
      mesNombre = parte.value.charAt(0).toUpperCase() + parte.value.slice(1);
    }
  });

  const textoFormateado = `${diaNombre}, ${diaNumero} de ${mesNombre} de ${añoNumero}`;

  const formatFecha = {
    texto: textoFormateado,
    diaNumero: Number(diaNumero),
    diaNombre,
    mesNumero: Number(mesNumero),
    mesNombre,
    año: añoNumero,
  };

  return formatFecha;
}

export function formatearFechaGoogleCalendar(dateStr, timeStr, timeFinStr) {
  if (timeStr === "" || timeStr === null) {
    timeStr = "00:00";
  }
  if (timeFinStr === "" || timeFinStr === null) {
    timeFinStr = "23:59";
  }

  const [day, month, year] = dateStr.split("/").map(Number);
  const [startHour, startMinute] = timeStr.split(":").map(Number);
  const [endHour, endMinute] = timeFinStr.split(":").map(Number);

  const start = new Date(
    Date.UTC(year, month - 1, day, startHour, startMinute)
  );
  const end = new Date(Date.UTC(year, month - 1, day, endHour, endMinute));

  const formatDate = (date) =>
    date
      .toISOString()
      .replace(/[-:]|\.\d{3}/g, "")
      .slice(0, 15) + "Z";

  return {
    start: formatDate(start),
    end: formatDate(end),
  };
}
