export const themes = {
  default: {
    "--bs-primary": "#fdf6d3",
    "--bs-secondary": "#c7b9c6",
    "--bs-tertiary": "#ddbe61",
    "--bs-quaternary": "#efb810",
    "--bs-quinary": "#ffffff",
    "--bs-success": "#198754",
    "--bs-info": "#b5c3e3",
    "--bs-warning": "#f8e6c1",
    "--bs-danger": "#e27b7e",
    "--bs-danger-light": "#d19ca3",
    "--bs-light": "#faf8f3",
    "--bs-dark": "#343a40",
    "--bs-dark-light": "#484f57",
    "--bs-body-bg": "#dedccf",
    "--bs-body-color": "#212529",
    "--bs-font-family-base": "Arial, sans-serif",
    "--bs-font-size-base": "1rem",
    "--bs-nav-link-color": "#ad8a1f",
    "--bs-emphasis-color": "#ad8a1f",
    "--bs-emphasis-color-rgb": "145, 92, 29",
    "--bs-border-color-translucent": "rgba(182, 146, 93, 0.6);",
  },
  clasico: {
    /* Custom Colors */
    "--bs-primary": "#ead9bcff",
    "--bs-secondary": "#c7b9c6",
    "--bs-success": "#e7d3e4",
    "--bs-info": "#b5c3e3",
    "--bs-warning": "#f8e6c1",
    "--bs-danger": "#d19ca3",
    "--bs-light": "#faf8f3",
    "--bs-dark": "#343a40",

    /* Additional Custom Colors */
    "--bs-blue": "#0d6efd",
    "--bs-indigo": "#6610f2",
    "--bs-purple": "#6f42c1",
    "--bs-pink": "#d63384",
    "--bs-red": "#dc3545",
    "--bs-orange": "#fd7e14",
    "--bs-yellow": "#ffc107",
    "--bs-green": "#198754",
    "--bs-teal": "#20c997",
    "--bs-cyan": "#0dcaf0",
    "--bs-white": "#fff",
    "--bs-gray": "#6c757d",
    "--bs-gray-dark": "#343a40",
    "--bs-black": "#000000",

    /* Body Styling */
    "--bs-body-bg": "var(--bs-white)",
    "--bs-body-color": "#c7b9c6",
    "--bs-bg-primary": "#c9c59fff",
    "--bs-bg-secondary": "var(--bs-black)",
    "--bs-color-primary": "var(--bs-black)",
    "--bs-color-secondary": "#dea94d",
    "--bs-font-family-primary": "'Quicksand', sans-serif",
    "--bs-font-family-secondary": "'Caveat', cursive",
    "--bs-font-size-base": "1rem",
    "--bs-body-line-height": "1.5",

    /* Borders */
    "--bs-border-width": "1px",
    "--bs-border-style": "solid",
    "--bs-border-color": "#dee2e6",
    "--bs-border-radius": "0.25rem",
    "--bs-border-radius-sm": "0.2rem",
    "--bs-border-radius-lg": "0.3rem",

    /* Shadows */
    "--bs-box-shadow": "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)",
    "--bs-box-shadow-sm": "0 0.05rem 0.1rem rgba(0, 0, 0, 0.15)",
    "--bs-box-shadow-lg": "0 0.5rem 1rem rgba(0, 0, 0, 0.175)",

    /* Links */
    "--bs-link-color": "#ad8a1f",
    "--bs-link-hover-color": "#0056b3",

    /* Alerts */
    "--bs-alert-bg": "var(--bs-warning)",
    "--bs-alert-color": "var(--bs-dark)",
  },
  elegante: {
    "--bs-blue": "#0d6efd",
    "--bs-indigo": "#6610f2",
    "--bs-purple": "#6f42c1",
    "--bs-pink": "#d63384",
    "--bs-red": "#dc3545",
    "--bs-orange": "#fd7e14",
    "--bs-yellow": "#ffc107",
    "--bs-green": "#198754",
    "--bs-teal": "#20c997",
    "--bs-cyan": "#0dcaf0",
    "--bs-white": "#fff",
    "--bs-gray": "#6c757d",
    "--bs-gray-dark": "#343a40",
    "--bs-primary": "#fd5d5d",
    "--bs-secondary": "#BBBD98",
    "--bs-success": "#198754",
    "--bs-info": "#0dcaf0",
    "--bs-warning": "#ffc107",
    "--bs-danger": "#dc3545",
    "--bs-light": "#EEEEEE",
    "--bs-dark": "#2F2F2F",
    "--bs-black": "#000000",
    "--bs-font-sans-serif":
      "system-ui, -apple-system, Segoe UI, Roboto, Helvetica Neue, Arial, Noto Sans, Liberation Sans, sans-serif, Apple Color Emoji, Segoe UI Emoji, Segoe UI Symbol, Noto Color Emoji",
    "--bs-font-monospace":
      "SFMono-Regular, Menlo, Monaco, Consolas, Liberation Mono, Courier New, monospace",
    "--bs-gradient":
      "linear-gradient(180deg, rgba(255, 255, 255, 0.15), rgba(255, 255, 255, 0))",

    /* Body Styling */
    "--bs-body-bg": "var(--bs-white)",
    "--bs-body-color": "#212529",
    "--bs-bg-primary": "#14141480",
    "--bs-bg-secondary": "var(--bs-black)",
    "--bs-color-primary": "#222",
    "--bs-color-secondary": "var(--bs-black)",
    "--bs-font-family-primary": "'Quicksand', sans-serif",
    "--bs-font-family-secondary": "'Caveat', cursive",
    "--bs-font-size-base": "1rem",
    "--bs-body-line-height": "1.5",

    /* Borders */
    "--bs-border-width": "1px",
    "--bs-border-style": "solid",
    "--bs-border-color": "#dee2e6",
    "--bs-border-radius": "0.25rem",
    "--bs-border-radius-sm": "0.2rem",
    "--bs-border-radius-lg": "0.3rem",

    /* Shadows */
    "--bs-box-shadow": "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)",
    "--bs-box-shadow-sm": "0 0.05rem 0.1rem rgba(0, 0, 0, 0.15)",
    "--bs-box-shadow-lg": "0 0.5rem 1rem rgba(0, 0, 0, 0.175)",

    /* Links */
    "--bs-link-color": "#ad8a1f",
    "--bs-link-hover-color": "#0056b3",

    /* Alerts */
    "--bs-alert-bg": "var(--bs-warning)",
    "--bs-alert-color": "var(--bs-dark)",
  },
  minimalista: {
    // /* Custom Colors */
    "--bs-primary": "#a5b393",
    "--bs-secondary": "#da988a",
    "--bs-tertiary": "#7c9889",
    "--bs-quaternary": "#efb810",
    "--bs-quinary": "#ffffff",
    "--bs-success": "#e7d3e4",
    "--bs-info": "#b5c3e3",
    "--bs-warning": "#f8e6c1",
    "--bs-danger": "#d19ca3",
    "--bs-light": "#faf8f3",
    "--bs-dark": "#343a40",

    /* Additional Custom Colors */
    "--bs-blue": "#0d6efd",
    "--bs-indigo": "#6610f2",
    "--bs-purple": "#6f42c1",
    "--bs-pink": "#d63384",
    "--bs-red": "#dc3545",
    "--bs-orange": "#fd7e14",
    "--bs-yellow": "#ffc107",
    "--bs-green": "#198754",
    "--bs-teal": "#20c997",
    "--bs-cyan": "#0dcaf0",
    "--bs-white": "#fff",
    "--bs-gray": "#6c757d",
    "--bs-gray-dark": "#343a40",
    "--bs-black": "#000000",

    /* Body Styling */
    "--bs-body-bg": "var(--bs-white)",
    "--bs-body-color": "#212529",
    "--bs-bg-primary": "#14141480",
    "--bs-bg-secondary": "var(--bs-black)",
    "--bs-color-primary": "#222",
    "--bs-color-secondary": "var(--bs-black)",
    "--bs-font-family-primary": "'Quicksand', sans-serif !important",
    "--bs-font-family-secondary": "'Caveat', cursive !important",
    "--bs-font-size-base": "1rem",
    "--bs-body-line-height": "1.5",

    /* Borders */
    "--bs-border-width": "1px",
    "--bs-border-style": "solid",
    "--bs-border-color": "#dee2e6",
    "--bs-border-radius": "0.25rem",
    "--bs-border-radius-sm": "0.2rem",
    "--bs-border-radius-lg": "0.3rem",

    /* Shadows */
    "--bs-box-shadow": "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)",
    "--bs-box-shadow-sm": "0 0.05rem 0.1rem rgba(0, 0, 0, 0.15)",
    "--bs-box-shadow-lg": "0 0.5rem 1rem rgba(0, 0, 0, 0.175)",

    /* Links */
    "--bs-link-color": "#ad8a1f",
    "--bs-link-hover-color": "#0056b3",

    /* Alerts */
    "--bs-alert-bg": "var(--bs-warning)",
    "--bs-alert-color": "var(--bs-dark)",
  },
  narrativo: {
    /* Custom Colors */
    "--bs-primary": "#121F38",
    "--bs-secondary": "#E47A2E",
    "--bs-success": "#e7d3e4",
    "--bs-info": "#b5c3e3",
    "--bs-warning": "#f8e6c1",
    "--bs-danger": "#d19ca3",
    "--bs-light": "#faf8f3",
    "--bs-dark": "#343a40",

    /* Additional Custom Colors */
    "--blue": "#007bff",
    "--indigo": "#6610f2",
    "--purple": "#6f42c1",
    "--pink": "#e83e8c",
    "--red": "#dc3545",
    "--orange": "#fd7e14",
    "--yellow": "#ffc107",
    "--green": "#28a745",
    "--teal": "#20c997",
    "--cyan": "#17a2b8",
    "--white": "#fff",
    "--gray": "#6c757d",
    "--gray-dark": "#343a40",
    "--primary": "#E47A2E",
    "--secondary": "#EDF5F7",
    "--success": "#28a745",
    "--info": "#17a2b8",
    "--warning": "#ffc107",
    "--danger": "#dc3545",
    "--light": "#FFFFFF",
    "--dark": "#121F38",
    "--breakpoint-xs": "0",
    "--breakpoint-sm": "576px",
    "--breakpoint-md": "768px",
    "--breakpoint-lg": "992px",
    "--breakpoint-xl": "1200px",

    /* Body Styling */
    "--bs-body-bg": "var(--bs-white)",
    "--bs-body-color": "#212529",
    "--bs-bg-primary": "#14141480",
    "--bs-bg-secondary": "var(--bs-black)",
    "--bs-color-primary": "#222",
    "--bs-color-secondary": "var(--bs-black)",

    "--font-family-sans-serif": "Montserrat, sans-serif",
    "--font-family-monospace":
      "SFMono-Regular, Menlo, Monaco, Consolas, Liberation Mono, Courier New, monospace",
    "--bs-font-family-primary": "'Quicksand', sans-serif",
    "--bs-font-family-secondary": "'Caveat', cursive",
    "--bs-font-size-base": "1rem",
    "--bs-body-line-height": "1.5",

    /* Borders */
    "--bs-border-width": "1px",
    "--bs-border-style": "solid",
    "--bs-border-color": "#dee2e6",
    "--bs-border-radius": "0.25rem",
    "--bs-border-radius-sm": "0.2rem",
    "--bs-border-radius-lg": "0.3rem",

    /* Shadows */
    "--bs-box-shadow": "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)",
    "--bs-box-shadow-sm": "0 0.05rem 0.1rem rgba(0, 0, 0, 0.15)",
    "--bs-box-shadow-lg": "0 0.5rem 1rem rgba(0, 0, 0, 0.175)",

    /* Links */
    "--bs-link-color": "#ad8a1f",
    "--bs-link-hover-color": "#0056b3",

    /* Alerts */
    "--bs-alert-bg": "var(--bs-warning)",
    "--bs-alert-color": "var(--bs-dark)",
  },
  romantico: {},
  vintage: {
    /* Custom Colors */
    "--bs-primary": "#C78665",
    "--bs-secondary": "#f7bea1",
    "--bs-success": "#e7d3e4",
    "--bs-info": "#b5c3e3",
    "--bs-warning": "#f8e6c1",
    "--bs-danger": "#d19ca3",
    "--bs-light": "#faf8f3",
    "--bs-dark": "#343a40",

    /* Additional Custom Colors */
    "--bs-blue": "#0d6efd",
    "--bs-indigo": "#6610f2",
    "--bs-purple": "#6f42c1",
    "--bs-pink": "#d63384",
    "--bs-red": "#dc3545",
    "--bs-orange": "#fd7e14",
    "--bs-yellow": "#ffc107",
    "--bs-green": "#198754",
    "--bs-teal": "#20c997",
    "--bs-cyan": "#0dcaf0",
    "--bs-white": "#fff",
    "--bs-gray": "#6c757d",
    "--bs-gray-dark": "#343a40",
    "--bs-black": "#000000",

    /* Body Styling */
    "--bs-body-bg": "var(--bs-white)",
    "--bs-body-color": "#212529",
    "--bs-bg-primary": "#14141480",
    "--bs-bg-secondary": "var(--bs-black)",
    "--bs-color-primary": "#222",
    "--bs-color-secondary": "var(--bs-black)",
    "--bs-font-family-primary": "'Quicksand', sans-serif",
    "--bs-font-family-secondary": "'Caveat', cursive",
    "--bs-font-size-base": "1rem",
    "--bs-body-line-height": "1.5",

    /* Borders */
    "--bs-border-width": "1px",
    "--bs-border-style": "solid",
    "--bs-border-color": "#dee2e6",
    "--bs-border-radius": "0.25rem",
    "--bs-border-radius-sm": "0.2rem",
    "--bs-border-radius-lg": "0.3rem",

    /* Shadows */
    "--bs-box-shadow": "0 0.125rem 0.25rem rgba(0, 0, 0, 0.075)",
    "--bs-box-shadow-sm": "0 0.05rem 0.1rem rgba(0, 0, 0, 0.15)",
    "--bs-box-shadow-lg": "0 0.5rem 1rem rgba(0, 0, 0, 0.175)",

    /* Links */
    "--bs-link-color": "#ad8a1f",
    "--bs-link-hover-color": "#0056b3",

    /* Alerts */
    "--bs-alert-bg": "var(--bs-warning)",
    "--bs-alert-color": "var(--bs-dark)",
  },
};
