import { api } from "./apiClient";

export async function getSession() {
  try {
    const response = await api.get("/session/get");

    if (response) {
      let session = response.session;

      if (typeof session === "string") {
        session = JSON.parse(session);
      }

      return session !== null ? session : null;
    } else {
      return null;
    }
  } catch (error) {
    console.error("Error get session:", error);
    return null;
  }
}
