export function openingLetter() {
  if (typeof window === "undefined") return;

  const messageCustom = new URLSearchParams(window.location.search).get(
    "message"
  );
  if (messageCustom) {
    const mainMessage = document.getElementById("mainMessage");
    if (mainMessage) {
      mainMessage.textContent = decodeURI(messageCustom);
    }
  }

  document.body.classList.add("no-scroll");

  function handleOpenLetter() {
    const openLetterButton = document.getElementById("openLetter");
    if (!openLetterButton) return;

    openLetterButton.classList.add("open-btn");
    openLetterButton.style.opacity = 0;

    const coverElement = document.querySelector(".cover");
    if (coverElement) {
      coverElement.classList.add("open-cover");
    }

    setTimeout(() => {
      if (coverElement) {
        coverElement.style.zIndex = -1;
      }

      const paperElement = document.querySelector(".paper");
      if (paperElement) {
        paperElement.classList.add("open-paper");
      }

      document.body.classList.remove("no-scroll");

      setTimeout(() => {
        document.getElementById("letterContainer")?.classList.add("zoom-out");
        document.getElementById("modalOverlay")?.classList.add("hidden");
      }, 500);
    }, 500);
  }

  function handlePlayAudio() {
    const audioElement = document.getElementById("musicLocal");
    if (audioElement) {
      audioElement.play();
      audioElement.muted = false;
    }

    /*  if (window.playerRef && window.playerRef.playVideo) {
        window.playerRef.playVideo();
        clearInterval(interval);
      }
*/
    window.dispatchEvent(new Event("playMusic"));
  }

  setTimeout(() => {
    const openLetterButton = document.getElementById("openLetter");
    if (openLetterButton) {
      openLetterButton.addEventListener("click", handleOpenLetter);
      openLetterButton.addEventListener("click", handlePlayAudio, {
        once: true,
      });
    }
  }, 500);
}
