const API_URL = process.env.NEXT_PUBLIC_API_URL;
const API_USER = process.env.NEXT_PUBLIC_API_USER;
const API_PASS = process.env.NEXT_PUBLIC_API_PASS;

const getAuthHeader = () => {
  const credentials = btoa(`${API_USER}:${API_PASS}`);
  return `Basic ${credentials}`;
};

async function request(method, endpoint, data = null, extraOptions = {}) {
  try {
    const url = `${API_URL}${endpoint}`;

    const headers = {
      Authorization: getAuthHeader(),
      ...(method !== "GET" && method !== "HEAD"
        ? { "Content-Type": "application/json" }
        : {}),
      ...(extraOptions.headers || {}),
    };

    const options = {
      method,
      headers,
      credentials: "include",
      ...(data ? { body: JSON.stringify(data) } : {}),
      ...extraOptions,
    };

    const response = await fetch(url, options);
    const contentType = response.headers.get("content-type");

    if (!response.ok) {
      const error = contentType?.includes("application/json")
        ? await response.json()
        : await response.text();
      throw new Error(error?.message || error || `Error ${response.status}`);
    }

    return contentType?.includes("application/json")
      ? await response.json()
      : await response.text();
  } catch (err) {
    return null;
  }
}

export const api = {
  get: (endpoint, options = {}) => request("GET", endpoint, null, options),
  post: (endpoint, data, options = {}) =>
    request("POST", endpoint, data, options),
  put: (endpoint, data, options = {}) =>
    request("PUT", endpoint, data, options),
  delete: (endpoint, options = {}) =>
    request("DELETE", endpoint, null, options),
};
