"use client";

import { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faAnglesRight,
  faPencil,
  faSave,
} from "@fortawesome/free-solid-svg-icons";

export default function Mantenedor_Novios({ datos }) {
  
  const [editando, setEditando] = useState(false);

  const habilitarEdicion = (nombre) => {
    setEditando((prev) => ({
      ...prev,
      [nombre]: !prev[nombre],
    }));
  };

  const handleChange = (e) => {
    const { name, value } = e.target;
    if (name === "password") {
      setPassword(value);
    } else if (name === "password2") {
      setPassword2(value);
    } else {
      setSession((prevSession) => ({
        ...prevSession,
        [name]: value,
      }));
    }
  };

  return (
    <section id="novios" className="mt-3">
      <div className="card">
        <div className="card-header p-0 m-0" id="head-novios">
          <button
            className="btn p-2 m-0 w-100 cursor-pointer d-flex justify-content-between align-items-center collapsed"
            data-bs-toggle="collapse"
            data-bs-target="#collapse-novios"
            aria-expanded="false"
            aria-controls="collapse-novios"
          >
            <h4 className="fw-bold p-0 m-0">Novios</h4>
            <FontAwesomeIcon className="accordion-icon" icon={faAnglesRight} />
          </button>
        </div>

        <div
          id="collapse-novios"
          className="collapse"
          aria-labelledby="head-novios"
          data-bs-parent="#accordion"
        >
          <div className="card-body">
            <div className="row col-md-12 mb-4">
              <div className="col-md-3">
                <label className="fw-bold">Nombre novio</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.nombre_novio ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Apellido novio</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.apellido_novio ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Foto novio</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.foto_novio ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Descripción novio</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.descripcion_novio ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
            </div>
            <div className="row col-md-12 mb-4">
              <div className="col-md-3">
                <label className="fw-bold">Nombre novia</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.nombre_novia ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Apellido novia</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.apellido_novia ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Foto novia</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.foto_novia ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Descripción novia</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.descripcion_novia ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
            </div>
            <div className="row col-md-12 mb-4">
              <div className="col-md-3">
                <label className="fw-bold">Fecha matrimonio</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.fecha_evento ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Url evento calendario</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.url_fecha_evento ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Direccion</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.dir_evento ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Url direccion</label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.url_dir_evento ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Url frame direccion </label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.embed_dir_evento ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Url musica </label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.url_musica ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
              <div className="col-md-3">
                <label className="fw-bold">Foto portada </label>
                <div className="form-group">
                  <input
                    type="text"
                    className="form-control"
                    name="nombres"
                    id="nombres"
                    value={datos?.foto_portada ?? ""}
                    onChange={handleChange}
                    disabled={!editando}
                  />
                </div>
              </div>
            </div>
          </div>
          <div className="card-footer">
            <div className="form-group py-3">
              {!editando["usuarios"] ? (
                <button
                  className="btn btn-primary"
                  type="button"
                  onClick={habilitarEdicion}
                >
                  <FontAwesomeIcon icon={faPencil}></FontAwesomeIcon> Modificar
                </button>
              ) : (
                <button
                  className="btn btn-success"
                  type="button"
                  onClick={handleSubmit}
                >
                  <FontAwesomeIcon icon={faSave}></FontAwesomeIcon> Guardar
                </button>
              )}
            </div>
          </div>
        </div>
      </div>
    </section>
  );
}
