"use client";

import { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faSave } from "@fortawesome/free-solid-svg-icons";
import ModalEmpty from "../ModalEmpty";
import PhoneInput from "react-phone-input-2";
import { isValidPhoneNumber } from "libphonenumber-js";
import "react-phone-input-2/lib/bootstrap.css";

export default function Mantenedor_Invitados({ id_invitado, id_usuario }) {
  const [loading, setLoading] = useState(null);
  const [resultOk, setResultOk] = useState(null);
  const [resultErr, setResultErr] = useState(null);
  const [showModal, setShowModal] = useState(false);
  const [errorTelefono, setErrorTelefono] = useState(null);
  const [formData, setFormData] = useState({
    id_usuario: id_usuario,
    nombres: "",
    ctd: "",
    telefono: "",
    mensaje: "",
  });

  useEffect(() => {
    if (
      id_invitado !== undefined ||
      id_invitado !== null ||
      id_invitado !== 0
    ) {
      /*    setFormData({
        nombres: datos.nombres,
        telefono: datos.telefono,
      });
    */
    }
  }, [id_invitado, id_usuario]);

  const handleChange = (e) => {
    const { name, value } = e.target;

    let newValue = value;

    if (name === "ctd") {
      const num = Number(value);

      if (num > 0) {
        newValue = num;
      } else {
        newValue = "";
      }
    }

    if (name === "telefono") {
      if (isValidPhoneNumber("+" + value)) {
        setErrorTelefono(null);
      } else {
        setErrorTelefono("Número inválido para el país seleccionado");
      }
    }

    setFormData((prevFormData) => ({
      ...prevFormData,
      [name]: newValue,
    }));
  };

  const handleSubmit = async () => {
    let validaForm = false;

    console.log({
      nombres: formData.nombres,
      ctd: formData.ctd,
      telefono: formData.telefono,
      mensaje: formData.mensaje,
    });

    if (!validaForm) return;

    setLoading(true);
    try {
      const data = await api.put("/usuarios/updateUsuario", {
        id: formData.id,
        nombres: formData.nombres,
        usuario: formData.usuario,
        email: formData.email,
        telefono: formData.telefono,
        id_rol: formData.id_rol,
        id_template: formData.id_template,
        estado: formData.estado,
      });

      if (data) {
        setResultOk(data.message);

        const resFormData = await getFormData();

        const menuData = resFormData.menuData;
        const userData = data.userData;

        const formData = await api.post("/formData/create", {
          userData,
          menuData,
        });
      } else {
        setResultErr(data.message);
      }
    } catch (error) {
      setResultErr(error.message);
    } finally {
      setLoading(false);
    }
  };

  return (
    <>
      <button
        className="btn btn-success p-3"
        onClick={() => setShowModal(true)}
      >
        Nuevo Invitado
      </button>
      {showModal && (
        <ModalEmpty
          title="Nuevo Invitado"
          size="large"
          onClose={() => setShowModal(false)}
          closeOnOutsideClick={false}
          buttons={
            <>
              <div className="d-flex justify-content-between">
                <button
                  className="btn btn-secondary px-4"
                  onClick={() => setShowModal(false)}
                >
                  Cancelar
                </button>
                <button
                  className="btn btn-success px-4"
                  type="button"
                  onClick={handleSubmit}
                >
                  <FontAwesomeIcon icon={faSave}></FontAwesomeIcon> Guardar
                </button>
              </div>
            </>
          }
        >
          <section id="new_invitado" className="">
            <div className="p-0 m-0 " id="new-invitado">
              {resultOk && showAlert && (
                <div className="alert alert-success" role="alert">
                  {resultOk}
                  <button
                    type="button"
                    className="close"
                    data-dismiss="alert"
                    aria-label="Close"
                    onClick={() => setShowAlert(false)}
                  >
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
              )}
              {resultErr && showAlert && (
                <div className="alert alert-danger" role="alert">
                  {resultErr}
                  <button
                    type="button"
                    className="close"
                    data-dismiss="alert"
                    aria-label="Close"
                    onClick={() => setShowAlert(false)}
                  >
                    <span aria-hidden="true">&times;</span>
                  </button>
                </div>
              )}
              <div className="row">
                <div className="col-md-12">
                  <div className="col-md-8 mt-3">
                    <label className="fw-bold">Nombres</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control p-3"
                        name="nombres"
                        id="nombres"
                        value={formData.nombres ?? ""}
                        onChange={handleChange}
                      />
                    </div>
                  </div>
                  <div className="col-md-2 mt-3">
                    <label className="fw-bold">Cantidad</label>
                    <div className="form-group">
                      <input
                        type="number"
                        className="form-control p-3"
                        name="ctd"
                        id="ctd"
                        value={formData.ctd ?? ""}
                        onChange={handleChange}
                      />
                    </div>
                  </div>
                  <div className="col-md-4 mt-3">
                    <label className="fw-bold">Telefono</label>
                    <div className="form-group">
                      <PhoneInput
                        country={"cl"}
                        value={formData.telefono}
                        onChange={(value) =>
                          handleChange({ target: { name: "telefono", value } })
                        }
                        inputClass="form-control p-3 px-0"
                        containerClass="react-tel-input"
                        disableCountryCode={false}
                        disableDropdown={false}
                      />
                      {errorTelefono && (
                        <div className="text-danger mt-1">{errorTelefono} </div>
                      )}
                    </div>
                  </div>
                  <div className="col-md-10 mt-3">
                    <label className="fw-bold">
                      {"(Opcional) Mensaje personalizado a tu invitado"}
                    </label>
                    <div className="form-group">
                      <textarea
                        type="text"
                        className="form-control p-3"
                        rows="4"
                        name="mensaje"
                        id="mensaje"
                        value={formData.mensaje ?? ""}
                        onChange={handleChange}
                      />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </section>
        </ModalEmpty>
      )}
    </>
  );
}
