import "@/styles/custom-design-vintage.css";
import Music from "@/components/designs/elementos/Music";
import Countdown from "@/components/designs/elementos/Countdown";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import { formatearFecha } from "@/utils/formatearFecha";
import Gallery from "./elementos/Gallery";
import ConfirmarAsistencia from "./elementos/ConfirmarAsistencia";
import Regalos from "./elementos/Gift";
import { SvgCalendar } from "../icons/SvgIcons";
import CustomThemes from "@/components/CustomThemes";
import { themes } from "@/libs/themes";
import Invitado from "./elementos/invitado";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faClock, faHeart } from "@fortawesome/free-solid-svg-icons";

export default function vintage({ datos, setYtLoad }) {
  const fecha_evento = formatearFecha(datos.novios.fecha_evento);
  const fecha_limite = formatearFecha(datos.novios.fecha_limite);

  return (
    <>
      <CustomThemes theme={themes.vintage} />
      <OpeningLetter />
      {/* header*/}
      <header id="header">
        <div className="header-area ">
          <div id="sticky-header" className="main-header-area">
            <div className="container">
              <div className="row align-items-center">
                <div className="col-xl-3 col-lg-3"></div>
                <div className="col-xl-9 col-lg-9">
                  <div className="main-menu  d-none d-lg-block">
                    <nav>
                      <ul id="navigation">
                        <li>
                          <a className="active" href="#header">
                            Inivio
                          </a>
                        </li>
                        <li>
                          <a href="#story">Historia</a>
                        </li>
                        <li>
                          <a href="#gallery">Galeria</a>
                        </li>
                        <li>
                          <a href="#timeLine">Cronograma</a>
                        </li>
                        <li>
                          <a href="#confirmar">Confirmar</a>
                        </li>
                      </ul>
                    </nav>
                  </div>
                </div>
                <div className="col-12">
                  <div className="mobile_menu d-block d-lg-none"></div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </header>
      {/*/ header*/}

      {/* slider_area */}
      <div className="slider_area ">
        <div
          className="slider_area_inner overlay2"
          style={{
            backgroundImage: `url(${datos.novios.foto_portada})`,
          }}
        >
          <div className="slider_text text-center">
            <div className="text_inner">
              <h4>
                {fecha_evento.diaNumero +
                  " " +
                  fecha_evento.mesNombre +
                  " " +
                  fecha_evento.año}
              </h4>
              <h3>Matrimonio de</h3>
              <h3>
                {datos.novios.nombre_novio}
                <br /> & <br />
                {datos.novios.nombre_novia}
              </h3>
            </div>
          </div>
        </div>
      </div>
      {/*/ slider_area */}

      {/* wedding_countdown */}
      <div className="weeding_countdown_area">
        <div className="flowaers_top d-none d-lg-block">
          <img
            src="/assets/images/designs/invitaciones/vintage/flower-top.png"
            alt=""
          />
        </div>
        <div className="flowaers_bottom d-none d-lg-block">
          <img
            src="/assets/images/designs/invitaciones/vintage/flower-bottom.png"
            alt=""
          />
        </div>
        <div className="container">
          <div className="row">
            <div className="col-xl-2"></div>
            <div className="col-xl-8 title-encab d-flex flex-column justify-content-center">
              <p className="lh-sm text-center fs-3">
                {datos.novios.versiculo_text}
              </p>
              <p className="lh-sm text-end fs-3 mt-5">
                {datos.novios.versiculo_ref}
              </p>
            </div>
            <div className="col-xl-2"></div>
          </div>
          <Invitado
            invitado={datos.invitados}
            texto_personalizado={datos.novios.texto_personalizado}
          ></Invitado>
          <div className="row">
            <div className="col-xl-12">
              <div className="section_title text-center">
                <img
                  src="/assets/images/designs/invitaciones/vintage/flowers.png"
                  alt=""
                />
                <span className="fs-1">
                  {fecha_evento.diaNumero +
                    " de " +
                    fecha_evento.mesNombre +
                    " de " +
                    fecha_evento.año}
                </span>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-xl-12">
              <Countdown fecha_evento={datos.novios.fecha_evento} />
            </div>
          </div>
          <div className="row mb-5">
            <div className="col-md-12 d-flex flex-column justify-content-center align-items-center">
              <a
                className="text-decoration-none text-black text-center img-md"
                target="_blank"
                href={datos.novios.url_fecha_evento}
                title="calendar"
              >
                <SvgCalendar className="color-primary icon svg-4x" />
                <br />
                <span className="lh-sm mt-4 text-center">
                  Guarda la fecha en tu calendario
                </span>
              </a>
            </div>
          </div>
        </div>
      </div>
      {/*/ wedding_countdown */}

      {/* our_love-story */}
      <div className="love_story_area" id="story">
        <div className="container">
          <div className="row">
            <div className="col-xl-12">
              <div className="section_title text-center">
                <img
                  src="/assets/images/designs/invitaciones/vintage/flowers.png"
                  alt=""
                />
                <h3>Nuestra historia de amor</h3>
              </div>
            </div>
          </div>
          <div className="row">
            <div className="col-xl-4 col-md-6 col-lg-4">
              <div className="single_lover_story text-center">
                <div className="story_thumb circle-mask">
                  <img src={datos.novios.foto_novio} alt="" />
                </div>
                <span>Novio</span>
                <h3>
                  {datos.novios.nombre_novio +
                    " " +
                    datos.novios.apellidos_novio}
                </h3>
                <p>{datos.novios.descripcion_novio}</p>
              </div>
            </div>
            <div className="col-xl-4 col-md-6 col-lg-4">
              <div className="weding_time_line text-center">
                <div
                  className="single_time_line mt-2"
                  style={{
                    backgroundImage: `url(${datos.history.primera_foto})`,
                  }}
                >
                  <div className="overlay-bg" />
                  <div className="content">
                    <h3>El día en que todo comenzó</h3>
                    <h4>{datos.history.primera_fecha}</h4>
                    <p>{datos.history.primera_cita}</p>
                  </div>
                </div>
                <div
                  className="single_time_line mt-2"
                  style={{
                    backgroundImage: `url(${datos.history.segunda_foto})`,
                  }}
                >
                  <div className="overlay-bg" />
                  <div className="content">
                    <h3>Nuestra Primera Cita</h3>
                    <h4>{datos.history.segunda_fecha}</h4>
                    <p>{datos.history.segunda_cita}</p>
                  </div>
                </div>
                <div
                  className="single_time_line mt-2"
                  style={{
                    backgroundImage: `url(${datos.history.tercera_foto})`,
                  }}
                >
                  <div className="overlay-bg" />
                  <div className="content">
                    <h3>El &quot;Sí&quot; que selló todo</h3>
                    <h4>{datos.history.tercera_fecha}</h4>
                    <p>{datos.history.tercera_cita}</p>
                  </div>
                </div>
                <div
                  className="single_time_line mt-2"
                  style={{
                    backgroundImage: `url(${datos.history.cuarta_foto})`,
                  }}
                >
                  <div className="overlay-bg" />
                  <div className="content">
                    <h3>A un paso de nuestro &quot;Siempre Juntos&quot;</h3>
                    <h4>{datos.history.cuarta_fecha}</h4>
                    <p>{datos.history.cuarta_cita}</p>
                  </div>
                </div>
              </div>
            </div>
            <div className="col-xl-4 col-lg-4">
              <div className="single_lover_story text-center">
                <div className="story_thumb circle-mask">
                  <img src={datos.novios.foto_novia} alt="" />
                </div>
                <span>Novia</span>
                <h3>
                  {datos.novios.nombre_novia +
                    " " +
                    datos.novios.apellidos_novia}
                </h3>
                <p>{datos.novios.descripcion_novia}</p>
              </div>
            </div>
          </div>
        </div>
      </div>
      {/*/ our_love-story */}

      {/* gallery_area  */}
      <Gallery
        images={datos.gallery}
        url_section_image={"/assets/images/designs/invitaciones/vintage/flowers.png"}
        url_base={`${process.env.NEXT_PUBLIC_IMAGE_BASE_URL}/${datos.usuario.id_usuario}/gallery`}
      ></Gallery>
      {/*/ gallery_area  */}

      {/* program_details */}
      {datos.cronograma.length > 0 && (
        <div className="program_details_area" id="timeLine">
          <div className="container">
            <div className="row">
              <div className="col-xl-12">
                <div className="section_title text-center">
                  <img
                    src="/assets/images/designs/invitaciones/vintage/flowers.png"
                    alt=""
                  />
                  <h3>Cronograma</h3>
                </div>
              </div>
            </div>
            <div className="row">
              {datos.cronograma.map((item, index) => (
                <div className="col-xl-3 col-lg-3" key={`crono-(${item.id})`}>
                  <div
                    className="single_program text-center"
                    style={{
                      backgroundImage: `url(${item.url})`,
                    }}
                  >
                    <div className="program_inner ">
                      <span>
                        {item.hora ? (
                          item.hora
                        ) : (
                          <FontAwesomeIcon icon={faClock}></FontAwesomeIcon>
                        )}
                      </span>
                      <h3>{item.nombre}</h3>
                      <p>{item.descripcion}</p>
                      <img
                        width={"50%"}
                        src="/assets/images/designs/invitaciones/vintage/flowers.png"
                        //  src="/assets/images/designs/invitaciones/vintage/ornaments.png"
                        alt=""
                      />
                    </div>
                  </div>
                </div>
              ))}
            </div>
          </div>
        </div>
      )}
      {/*/ program_details */}

      <Regalos datos={datos.gift} />

      {/* attend_area */}
      <div
        className={`attending_area ${
          datos.invitados.estado !== null && datos.invitados.estado !== 2
            ? "d-none"
            : ""
        }`}
        id="confirmar"
      >
        <div className="container">
          <div className="row mb-6">
            <div className="col-md-1"></div>
            <div className="col-md-10 d-flex flex-column justify-content-center align-items-center">
              <p className="lh-sm fs-3 text-center">
                {datos.novios.texto_confirmar}
              </p>
            </div>
            <div className="col-md-1"></div>
          </div>
          <div className="row">
            <div className="col-xl-10 offset-xl-1 col-lg-10 offset-lg-1">
              <div className="main_attending_area">
                <div className="flower_1 d-none d-lg-block">
                  <img
                    src="/assets/images/designs/invitaciones/vintage/flower-top.png"
                    alt=""
                  />
                </div>
                <div className="flower_2 d-none d-lg-block">
                  <img
                    src="/assets/images/designs/invitaciones/vintage/flower-bottom.png"
                    alt=""
                  />
                </div>
                <div className="row justify-content-center">
                  <div className="col-xl-7 col-lg-8">
                    <div className="popup_box ">
                      <div className="popup_inner">
                        <div className="form_heading text-center">
                          <h1 className="fs-1">
                            ¿Asistirás a nuestro matrimonio?
                          </h1>
                          <p className="fs-3 mt-3 mb-3">
                            {datos.novios.texto_limite + " "}
                          </p>
                          <p className="fs-3">
                            {fecha_limite.diaNumero +
                              " de " +
                              fecha_limite.mesNombre +
                              "  del " +
                              fecha_limite.año}
                          </p>
                        </div>
                        <ConfirmarAsistencia
                          id_usuario={datos.usuario.id_usuario}
                          telefono={datos.invitados.telefono}
                          estadoDB={datos.invitados.estado}
                          designe={datos.usuario.designe}
                          cupos={datos.invitados.ctd}
                          texto_confirmar_comentarios={
                            datos.novios.texto_confirmar_comentarios
                          }
                          permitir_ninios={datos.novios.permitir_ninios}
                          texto_permitir_ninios={
                            datos.novios.texto_permitir_ninios
                          }
                        />
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      {/* / attend_area */}

      {/* ================ contact section start ================= */}
      <section className="location_area" id="location">
        <div className="location_info">
          <div className="location_inner">
            <div className="location_top text-center">
              <h3>Ubicación</h3>
              <p>
                {datos.novios.dir_evento} <br />
              </p>
            </div>
          </div>
        </div>
        <iframe
          title="maps"
          className="maps"
          src={datos.novios.embed_dir_evento}
          allowFullScreen=""
          loading="lazy"
          referrerPolicy="no-referrer-when-downgrade"
        ></iframe>
      </section>

      <section id="audio">
        <Music
          link={datos.novios.url_musica}
          designe={datos.usuario.designe}
          setYtLoad={setYtLoad}
        ></Music>
      </section>

      {/* footer_start */}
      <footer className="footer mb-6">
        <div className="copy-right_text">
          <div className="container">
            <div className="footer_border"></div>
            <div className="row">
              <div className="col-xl-12">
                <p className="copy_right text-center">
                  Todos los derechos reservados &copy;MyBoda
                  <script>
                    document.write(new Date().getFullYear());
                  </script>{" "}
                  <FontAwesomeIcon icon={faHeart} /> Desarrollado por{" "}
                  <a href="https://myboda.cl" target="_blank">
                    Jiempy SpA
                  </a>
                </p>
              </div>
            </div>
          </div>
        </div>
      </footer>
    </>
  );
}
