import Cronograma from "@/components/designs/elementos/Cronograma";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import { formatearFecha } from "@/utils/formatearFecha";
import { useEffect } from "react";
import "@/styles/custom-design-romantico.css"
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faHeart } from "@fortawesome/free-solid-svg-icons";
import CustomThemes from "@/components/CustomThemes";
import { themes } from "@/libs/themes";

export default function Romantico(datos) {
  datos = datos.datos;
  const cronograma = datos.configs.filter(
    (config) => config.tipo_config === "cronograma"
  );

  const styles = datos.configs.filter(
    (config) => config.tipo_config === "styles"
  );

  useEffect(() => {
  }, []);
  return (
    <>
    <CustomThemes theme={themes.romantico} />
      <OpeningLetter />

      <div id="full-page">
        {/* Header Section Start */}
        <header className="">
          <div className="overlay"></div>
          <nav
            className="navbar navbar-expand-lg navbar-light fixed-top py-3 bg-light"
            data-navbar-on-scroll="data-navbar-on-scroll"
          >
            <div className="container mt-2">
              <button
                className="navbar-toggler collapsed order-lg-1 order-2 mobile-menu-btn"
                type="button"
                data-bs-toggle="collapse"
                data-bs-target="#navbarSupportedContent"
                aria-controls="navbarSupportedContent"
                aria-expanded="false"
                aria-label="Toggle navigation"
              >
                <i className="fa fa-bars"></i>
              </button>
              <div
                className="collapse navbar-collapse border-top border-lg-0 mt-4 mt-lg-0 order-lg-1 order-2 main-menu top-menu"
                id="navbarSupportedContent"
              >
                <ul className="navbar-nav me-auto mb-2 mb-lg-0">
                  <li>
                    <a className="nav-link" href="#intro">
                      Home
                    </a>
                  </li>
                  <li>
                    <a className="nav-link" href="#story">
                      Nuestra historia
                    </a>
                  </li>
                  <li>
                    <a className="nav-link" href="#gallery">
                      Galeria
                    </a>
                  </li>
                  <li>
                    <a className="nav-link" href="#event">
                      Evento
                    </a>
                  </li>
                  <li>
                    <a className="nav-link" href="#confirm">
                      Confirmar
                    </a>
                  </li>
                </ul>
              </div>
            </div>
          </nav>
        </header>
        <section className="section section-1">
          <div id="intro">
            <div className="intro-container">
              <div
                id="introCarousel"
                className="carousel slide carousel-fade"
                data-bs-ride="carousel"
              >
                <div className="carousel-indicators">
                  <button
                    type="button"
                    data-bs-target="#introCarousel"
                    data-bs-slide-to="0"
                    className="active"
                    aria-current="true"
                    aria-label="Slide 1"
                  ></button>
                  <button
                    type="button"
                    data-bs-target="#introCarousel"
                    data-bs-slide-to="1"
                    aria-label="Slide 2"
                  ></button>
                  <button
                    type="button"
                    data-bs-target="#introCarousel"
                    data-bs-slide-to="2"
                    aria-label="Slide 3"
                  ></button>
                </div>

                <div
                  className="carousel-inner"
                  role="listbox"
                  aria-label="carousel"
                >
                  <div className="carousel-item active">
                    <div className="carousel-background">
                      <img src="assets/images/slider-1.jpg" alt="" />
                    </div>
                    <div className="carousel-container">
                      <div className="carousel-content">
                        <h1>Tomás</h1>
                        <h2>&</h2>
                        <h1>Maria</h1>
                        <p>Vamos a contraer Matrimonio!</p>
                        <h4>24 de Agosto 2025</h4>
                        <a href="#confirm" className="btn btn-get-started">
                          Confirmo mi asistencia
                        </a>
                      </div>
                    </div>
                  </div>

                  <div className="carousel-item">
                    <div className="carousel-background">
                      <img src="assets/images/slider-2.jpg" alt="" />
                    </div>
                    <div className="carousel-container">
                      <div className="carousel-content">
                        <h1>Tomás</h1>
                        <h2>&</h2>
                        <h1>Maria</h1>
                        <p>Vamos a contraer Matrimonio!</p>
                        <h4>24 de Agosto 2025</h4>
                        <a href="#confirm" className="btn btn-primary">
                          Confirmo mi asistencia
                        </a>
                      </div>
                    </div>
                  </div>

                  <div className="carousel-item">
                    <div className="carousel-background">
                      <img src="assets/images/slider-3.jpg" alt="" />
                    </div>
                    <div className="carousel-container">
                      <div className="carousel-content">
                        <h1>Tomás</h1>
                        <h2>&</h2>
                        <h1>Maria</h1>
                        <p>Vamos a contraer Matrimonio!</p>
                        <h4>24 de Agosto 2025</h4>
                        <a href="#confirm" className="btn btn-primary">
                          Confirmo mi asistencia
                        </a>
                      </div>
                    </div>
                  </div>
                </div>

                <button
                  className="carousel-control-prev"
                  type="button"
                  data-bs-target="#introCarousel"
                  data-bs-slide="prev"
                >
                  <span
                    className="carousel-control-prev-icon"
                    aria-hidden="true"
                  ></span>
                  <span className="visually-hidden">Previous</span>
                </button>

                <button
                  className="carousel-control-next"
                  type="button"
                  data-bs-target="#introCarousel"
                  data-bs-slide="next"
                >
                  <span
                    className="carousel-control-next-icon"
                    aria-hidden="true"
                  ></span>
                  <span className="visually-hidden">Next</span>
                </button>
              </div>
            </div>
          </div>
        </section>
        {/* Header Section End */}

        {/* Story Section Start*/}
        <section className="section section-2 pt-5 pb-5">
          <div id="story">
            <div className="container">
              <div className="section-header">
                <h3>Nuestra historia de amor</h3>
              </div>
              <div className="row">
                <div className="col-md-12">
                  <h4>¡Vamos a contraer Matrimonio!</h4>
                  <p>
                    Nos conocimos una fria noche de otoño, estabamos en una cena
                    de amigos y fue amor a primera vista
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>
        {/* Story Section end */}

        {/* Gallery Section Start*/}
        <section className="section section-3 pt-5 pb-5">
          <div id="gallery">
            <div className="container">
              <div className="section-header">
                <h3>Nuestras Fotos</h3>
              </div>
              <div className="row">
                <div className="col-12">
                  <div className="gallery">
                    <div>
                      <img src="assets/images/gallery/gallery-1.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-2.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-3.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-4.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-5.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-6.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-7.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-8.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-9.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-10.jpg" alt="" />
                    </div>
                  </div>
                  <div className="gallery-nav">
                    <div>
                      <img src="assets/images/gallery/gallery-1.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-2.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-3.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-4.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-5.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-6.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-7.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-8.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-9.jpg" alt="" />
                    </div>
                    <div>
                      <img src="assets/images/gallery/gallery-10.jpg" alt="" />
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        {/* Gallery Section end */}

        {/* Fiesta Section Start*/}
        <section className="section section-4 pt-5 pb-5" id="event">
          <div id="Fiesta">
            <div className="container">
              <div className="section-header">
                <h3>El Matrimonio</h3>
              </div>
              <div className="row">
                <div className="col-6 text-right">
                  <h4>¿Cuando?</h4>
                  <p>24 de Agostro 2025 a las 19:00 Horas</p>
                </div>
                <div className="col-6 text-left">
                  <h4>¿Donde?</h4>
                  <p>
                    Green House, 4532 Harrison Street, San Francisco,
                    California, USA
                  </p>
                </div>
              </div>
            </div>
          </div>
        </section>
        {/* Fiesta Section end */}

        {/* Place Section Start*/}
        <section className="section section-5 pt-5 pb-5">
          <div id="place">
            <div className="container">
              <div className="section-header">
                <h3>¿Como llegar?</h3>
              </div>
              <div className="row">
                <div className="col-6 text-right">
                  <h4>Transporte</h4>
                  <p>Mensaje opcional</p>
                </div>
                <div className="col-6 text-left">
                  <h4>Alojamiento</h4>
                  <p>Mensaje opcional</p>
                </div>
              </div>
              <a href="#" data-toggle="modal" data-target="#modal-map">
                Ver en mapa
              </a>
            </div>
          </div>
        </section>
        {/* Place Section end */}

        {/* Modal For Map Start */}
        <div
          id="modal-map"
          className="modal fade"
          tabIndex="-1"
          role="dialog"
          aria-label="modal"
        >
          <div className="modal-dialog modal-lg">
            <div className="modal-content">
              <div className="modal-header">
                <button type="button" className="close" data-dismiss="modal">
                  &times;
                </button>
              </div>
              <div className="modal-body">
                <iframe
                  title="frame"
                  src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3154.930606514469!2d-122.41356888468323!3d37.74477217976484!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x808f7e5015e9a3f5%3A0xc462d58164911ffd!2s4532+Harrison+St%2C+San+Francisco%2C+CA+94110%2C+USA!5e0!3m2!1sen!2sbd!4v1555468110762!5m2!1sen!2sbd"
                  width="100%"
                  height="350"
                  allowFullScreen
                ></iframe>
              </div>
            </div>
          </div>
        </div>
        {/* Modal For Map End */}

        {/* Registry Section Start*/}
        <section className="section section-6 pt-5 pb-5">
          <div id="confirm">
            <div className="container">
              <div className="section-header">
                <h3>Confirmar</h3>
              </div>
              <div className="row">
                <div className="col-12">
                  <h4>
                    Estamos muy emocionados de celebrar contigo nuestro
                    matrimonio
                  </h4>

                  <div>
                    <button className="btn btn-primary" type="button">
                      No pordré asistir
                    </button>
                    <button className="btn btn-primary" type="button">
                      Confirmo mi asistencia
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
        {/* Registry Section end */}

        <a href="#intro" className="back-to-top" title="intro">
          <i className="fa fa-chevron-up"></i>
        </a>
        {/* Uncomment below i you want to use a preloader */}
        {/* <div id="preloader"></div> */}
      </div>

      <section>
        <audio id="music" controls>
          <source src="assets/audios/music.mp3" type="audio/mpeg" />
        </audio>
      </section>

      {/* Footer */}
      <footer className="footer mb-6">
        <div className="copy-right_text">
          <div className="container">
            <div className="footer_border"></div>
            <div className="row">
              <div className="col-xl-12">
                <p className="copy_right text-center m-5">
                  {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
                  Todos los derechos reservados &copy;MyBoda
                  <script>document.write(new Date().getFullYear());</script>
                  <FontAwesomeIcon icon={faHeart}/>{" "}
                  Desarrollado por
                 <a href="https://myboda.cl" target="_blank">
                    Jiempy SpA
                  </a>
                  {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
                </p>
              </div>
            </div>
          </div>
        </div>
      </footer>

      {/* JavaScript Libraries */}
      <script src="../../assets_myboda/js/jquery.min.js"></script>
      <script src="../../assets_myboda/js/bootstrap.bundle.min.js"></script>
      <script src="../../assets_myboda/js/fullpage.min.js"></script>
      <script src="../../assets_myboda/js/easing.min.js"></script>
      <script src="../../assets_myboda/js/hoverIntent.js"></script>
      <script src="../../assets_myboda/js/superfish.min.js"></script>
      <script src="../../assets_myboda/js/waypoints.min.js"></script>
      <script src="../../assets_myboda/js/owl.carousel.min.js"></script>
      <script src="../../assets_myboda/js/jquery.touchSwipe.min.js"></script>
      <script src="../../assets_myboda/js/slick.min.js"></script>
      <script src="../../assets_myboda/js/flipclock.min.js"></script>
      <script src="../../assets_myboda/js/opening-letter.js"></script>
      <script src="assets/js/main.js"></script>
    </>
  );
}
