import Cronograma from "@/components/designs/elementos/Cronograma";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import { formatearFecha } from "@/utils/formatearFecha";
import { useEffect } from "react";
import "@/styles/custom-design-narrativo.css";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faHeart } from "@fortawesome/free-solid-svg-icons";
import CustomThemes from "@/components/CustomThemes";
import { themes } from "@/libs/themes";

export default function Narrativo(datos) {
  datos = datos.datos;
  const cronograma = datos.configs.filter(
    (config) => config.tipo_config === "cronograma"
  );

  const styles = datos.configs.filter(
    (config) => config.tipo_config === "styles"
  );

  useEffect(() => {
  }, []);
  return (
    <>
    <CustomThemes theme={themes.narrativo} />
      <OpeningLetter />

      <div data-spy="scroll" data-target=".navbar" data-offset="51">
        {/* Navbar Start */}
        <nav className="navbar fixed-top shadow-sm navbar-expand-lg bg-dark navbar-dark py-3 py-lg-0 px-lg-5">
          <a href="index.html" className="navbar-brand d-block d-lg-none">
            <h1 className="font-secondary text-white mb-n2">
              Jack <span className="text-primary">&</span> Rose
            </h1>
          </a>
          <button
            type="button"
            className="navbar-toggler"
            data-toggle="collapse"
            data-target="#navbarCollapse"
            title="button"
          >
            <span className="navbar-toggler-icon"></span>
          </button>
          <div
            className="collapse navbar-collapse justify-content-between"
            id="navbarCollapse"
          >
            <div className="navbar-nav ml-auto py-0">
              <a href="#home" className="nav-item nav-link active">
                Inicio
              </a>
              <a href="#about" className="nav-item nav-link">
                Novios
              </a>
              <a href="#story" className="nav-item nav-link">
                Historia
              </a>
              <a href="#gallery" className="nav-item nav-link">
                Galeria
              </a>
            </div>
            <a
              href="index.html"
              className="navbar-brand mx-5 d-none d-lg-block"
            >
              <h1 className="font-secondary text-white mb-n2">
                Jack <span className="text-primary">&</span> Rose
              </h1>
            </a>
            <div className="navbar-nav mr-auto py-0">
              <a href="#family" className="nav-item nav-link">
                Familia
              </a>
              <a href="#event" className="nav-item nav-link">
                Evento
              </a>
              <a href="#rsvp" className="nav-item nav-link">
                Confirmar
              </a>
            </div>
          </div>
        </nav>
        {/* Navbar End */}

        {/* Carousel Start */}
        <div className="container-fluid p-0 mb-5 pb-5" id="home">
          <div
            id="header-carousel"
            className="carousel slide carousel-fade"
            data-ride="carousel"
          >
            <div className="carousel-inner">
              <div
                className="carousel-item position-relative active"
                style="height: 100vh; min-height: 400px;"
              >
                <img
                  className="position-absolute w-100 h-100"
                  src="assets/img/carousel-1.jpg"
                  style="object-fit: cover;"
                  alt=""
                />
                <div className="carousel-caption d-flex flex-column align-items-center justify-content-center">
                  <div className="p-3" style="max-width: 900px;">
                    <h1 className="display-1 font-secondary text-white mt-n3 mb-md-4">
                      Jack & Rose
                    </h1>
                    <div className="d-inline-block border-top border-bottom border-light py-3 px-4">
                      <h3
                        className="text-uppercase font-weight-normal text-white m-0"
                        style="letter-spacing: 2px;"
                      >
                        ¡Nos casamos!
                      </h3>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="carousel-item position-relative"
                style="height: 100vh; min-height: 400px;"
              >
                <img
                  className="position-absolute w-100 h-100"
                  src="assets/img/carousel-2.jpg"
                  style="object-fit: cover;"
                  alt=""
                />
                <div className="carousel-caption d-flex flex-column align-items-center justify-content-center">
                  <div className="p-3" style="max-width: 900px;">
                    <h1 className="display-1 font-secondary text-white mt-n3 mb-md-4">
                      Jack & Rose
                    </h1>
                    <div className="d-inline-block border-top border-bottom border-light py-3 px-4">
                      <h3
                        className="text-uppercase font-weight-normal text-white m-0"
                        style="letter-spacing: 2px;"
                      >
                        {"We're getting married"}
                      </h3>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <a
              className="carousel-control-prev justify-content-start"
              href="#header-carousel"
              data-slide="prev"
              title="carousel"
            >
              <div
                className="btn btn-primary px-0"
                style="width: 68px; height: 68px;"
              >
                <span className="carousel-control-prev-icon mt-3"></span>
              </div>
            </a>
            <a
              className="carousel-control-next justify-content-end"
              href="#header-carousel"
              data-slide="next"
              title="carousel"
            >
              <div
                className="btn btn-primary px-0"
                style="width: 68px; height: 68px;"
              >
                <span className="carousel-control-next-icon mt-3"></span>
              </div>
            </a>
          </div>
        </div>
        {/* Carousel End */}

        {/* About Start */}
        <div className="container-fluid py-5" id="about">
          <div className="container py-5">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-4">Novio & Novia</h1>
              <i className="far fa-heart text-dark"></i>
            </div>
            <div className="row m-0 mb-4 mb-md-0 pb-2 pb-md-0">
              <div className="col-md-6 p-0 text-center text-md-right">
                <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-5">
                  <h3 className="mb-3">El Novio</h3>
                  <p>
                    El es Jack, nacido en Madrid el 11 de septiembre 1992, le
                    gusta los paseos nocturnos por la playa, amante del deporte,
                    ama comer ravioles.
                  </p>
                  <h3 className="font-secondary font-weight-normal text-muted mb-3">
                    <i className="fa fa-male text-primary pr-3"></i>Jack
                  </h3>
                </div>
              </div>
              <div className="col-md-6 p-0" style="min-height: 400px;">
                <img
                  className="position-absolute w-100 h-100"
                  src="assets/img/about-1.jpg"
                  style="object-fit: cover;"
                  alt=""
                />
              </div>
            </div>
            <div className="row m-0">
              <div className="col-md-6 p-0" style="min-height: 400px;">
                <img
                  className="position-absolute w-100 h-100"
                  src="assets/img/about-2.jpg"
                  style="object-fit: cover;"
                  alt=""
                />
              </div>
              <div className="col-md-6 p-0 text-center text-md-left">
                <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-5">
                  <h3 className="mb-3">La Novia</h3>
                  <p>
                    Ella es Rose, nacida en Merida el 15 de febrero de 1995,
                    amante de los gatos, su deporte favorito es la natación y
                    ama las hamburguesas.
                  </p>
                  <h3 className="font-secondary font-weight-normal text-muted mb-3">
                    <i className="fa fa-female text-primary pr-3"></i>Rose
                  </h3>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* About End */}

        {/* Story Start */}
        <div className="container-fluid py-5" id="story">
          <div className="container pt-5 pb-3">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-4">
                Nuestra Historia de Amor
              </h1>
              <i className="far fa-heart text-dark"></i>
            </div>
            <div className="container timeline position-relative p-0">
              <div className="row">
                <div className="col-md-6 text-center text-md-right">
                  <img
                    className="img-fluid mr-md-3"
                    src="assets/img/story-1.jpg"
                    alt=""
                  />
                </div>
                <div className="col-md-6 text-center text-md-left">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4 ml-md-3">
                    <h4 className="mb-2">Primer Encuentro</h4>
                    <p className="text-uppercase mb-2">01 Enero 2010</p>
                    <p className="m-0">
                      Una hermosa tarde de verano nos vimos por primera vez en
                      el primer atardecer del año.
                    </p>
                  </div>
                </div>
              </div>
              <div className="row">
                <div className="col-md-6 text-center text-md-right">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4 mr-md-3">
                    <h4 className="mb-2">Primera Cita</h4>
                    <p className="text-uppercase mb-2">15 Enero 2010</p>
                    <p className="m-0">
                      Nuestra primera cita fue en un cine, despues de una tarde
                      de peliculas y palomitas caminamos por la ciudad, como si
                      nos conocieramos de toda la vida.
                    </p>
                  </div>
                </div>
                <div className="col-md-6 text-center text-md-left">
                  <img
                    className="img-fluid ml-md-3"
                    src="assets/img/story-2.jpg"
                    alt=""
                  />
                </div>
              </div>
              <div className="row">
                <div className="col-md-6 text-center text-md-right">
                  <img
                    className="img-fluid mr-md-3"
                    src="assets/img/story-3.jpg"
                    alt=""
                  />
                </div>
                <div className="col-md-6 text-center text-md-left">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4 ml-md-3">
                    <h4 className="mb-2">Propuesta</h4>
                    <p className="text-uppercase mb-2">08 Agosto 2015</p>
                    <p className="m-0">
                      Jack propuso invito a Rose a una cena en el mejor
                      restaurant de la ciudad, ese dia dijo: &quot;Te amaré el
                      resto de mi vida, ¿te casas conmigo?&quot;.
                    </p>
                  </div>
                </div>
              </div>
              <div className="row">
                <div className="col-md-6 text-center text-md-right">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4 mr-md-3">
                    <h4 className="mb-2">Compromiso</h4>
                    <p className="text-uppercase mb-2">08 Agosto 2015</p>
                    <p className="m-0">
                      Ese mismo dia nos comprometimos a tener una vida juntos.
                    </p>
                  </div>
                </div>
                <div className="col-md-6 text-center text-md-left">
                  <img
                    className="img-fluid ml-md-3"
                    src="assets/img/story-4.jpg"
                    alt=""
                  />
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Story End */}

        {/* Gallery Start */}
        <div
          className="container-fluid bg-gallery"
          id="gallery"
          style="padding: 120px 0; margin: 90px 0;"
        >
          <div
            className="section-title position-relative text-center"
            style="margin-bottom: 120px;"
          >
            <h1 className="font-secondary display-4 text-white">
              Nuestras Fotos
            </h1>
            <i className="far fa-heart text-white"></i>
          </div>
          <div className="owl-carousel gallery-carousel">
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-1.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-1.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-2.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-2.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-3.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-3.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-4.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-4.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-5.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-5.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
            <div className="gallery-item">
              <img
                className="img-fluid w-100"
                src="assets/img/gallery-6.jpg"
                alt=""
              />
              <a
                href="assets/img/gallery-6.jpg"
                data-lightbox="gallery"
                title="item"
              >
                <i className="fa fa-2x fa-plus text-white"></i>
              </a>
            </div>
          </div>
        </div>
        {/* Gallery End */}

        {/* Event Start */}
        <div className="container-fluid py-5" id="event">
          <div className="container py-5">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-4">Ceremonia de Boda</h1>
              <i className="far fa-heart text-dark"></i>
            </div>
            <div className="row justify-content-center">
              <div className="col-md-6 text-center">
                <h5 className="font-weight-normal text-muted mb-3 pb-3">
                  Queremos compartir contigo nuestro amor.
                </h5>
              </div>
            </div>
            <div className="row">
              <div className="col-md-6 border-right border-primary">
                <div className="text-center text-md-right mr-md-3 mb-4 mb-md-0">
                  <img
                    className="img-fluid mb-4"
                    src="assets/img/event-1.jpg"
                    alt=""
                  />
                  <h4 className="mb-3">La recepción</h4>
                  <p className="mb-2">Calle 7, Santiago, Chile</p>
                  <p className="mb-0">17:00 - 20:00 horas</p>
                </div>
              </div>
              <div className="col-md-6">
                <div className="text-center text-md-left ml-md-3">
                  <img
                    className="img-fluid mb-4"
                    src="assets/img/event-2.jpg"
                    alt=""
                  />
                  <h4 className="mb-3">Fiesta de Bodas</h4>
                  <p className="mb-2">Calle 7, Santiago, Chile</p>
                  <p className="mb-0">20:00 - 03:00 horas</p>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Event End */}

        {/* Friends & Family Start */}
        <div className="container-fluid py-5" id="family">
          <div className="container pt-5 pb-3">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-4">Amigos & Familia</h1>
              <i className="far fa-heart text-dark"></i>
            </div>
            <div className="row">
              <div className="col-12 text-center mb-2">
                <ul className="list-inline mb-4" id="portfolio-flters">
                  <li
                    className="btn btn-outline-primary font-weight-bold m-1 py-2 px-4"
                    data-filter=".first"
                  >
                    Novio
                  </li>
                  <li
                    className="btn btn-outline-primary font-weight-bold m-1 py-2 px-4"
                    data-filter=".second"
                  >
                    Novia
                  </li>
                </ul>
              </div>
            </div>
            <div className="row portfolio-container">
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item first">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/groomsmen-1.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item second">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/bridesmaid-1.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item first">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/groomsmen-2.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item second">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/bridesmaid-2.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item first">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/groomsmen-3.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
              <div className="col-lg-4 col-md-6 mb-4 portfolio-item second">
                <div className="position-relative mb-2">
                  <img
                    className="img-fluid w-100"
                    src="assets/img/bridesmaid-3.jpg"
                    alt=""
                  />
                  <div className="bg-secondary text-center p-4">
                    <h4 className="mb-3">Nombres</h4>
                    <p className="text-uppercase">Amigo</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Friends & Family End */}

        {/* RSVP Start */}
        <div className="container-fluid py-5" id="rsvp">
          <div className="container py-5">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-4">
                Unete a nuestro Matrimonio
              </h1>
              <i className="far fa-heart text-dark"></i>
            </div>
            <div className="row justify-content-center">
              <div className="col-lg-8">
                <div className="text-center">
                  <div>
                    <button
                      className="btn btn-danger font-weight-bold py-3 px-5"
                      type="submit"
                    >
                      No podré asistir
                    </button>
                    <button
                      className="btn btn-primary font-weight-bold py-3 px-5"
                      type="submit"
                    >
                      Confirmo mi Asistencia
                    </button>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* RSVP End */}

        <section>
          <audio id="music" controls>
            <source src="assets/audios/music.mp3" type="audio/mpeg" />
          </audio>
        </section>

        {/* Footer Start */}
        <div
          className="container-fluid bg-dark text-white py-5"
          id="contact"
          style="margin-top: 90px;"
        >
          <div className="container text-center">
            <div className="section-title position-relative text-center">
              <h1 className="font-secondary display-3 text-white">
                El amor siempre Triunfa
              </h1>
              <i className="far fa-heart text-white"></i>
            </div>
            <p className="m-5">
              {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
              Todos los derechos reservados &copy;MyBoda
              <script>document.write(new Date().getFullYear());</script>{" "}
              <FontAwesomeIcon icon={faHeart} /> Desarrollado por
              <a href="https://myboda.cl" target="_blank">
                Jiempy SpA
              </a>
              {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
            </p>
          </div>
        </div>
        {/* Footer End */}

        {/* Scroll to Bottom */}
        <i className="fa fa-2x fa-angle-down text-white scroll-to-bottom"></i>

        {/* Back to Top */}
        <a
          href="#"
          className="btn btn-lg btn-outline-primary btn-lg-square back-to-top"
          title="top"
        >
          <i className="fa fa-angle-double-up"></i>
        </a>

        {/* JavaScript Libraries */}
        <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
        <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.bundle.min.js"></script>
        <script src="../../assets_myboda/lib/easing/easing.min.js"></script>
        <script src="../../assets_myboda/lib/waypoints/waypoints.min.js"></script>
        <script src="../../assets_myboda/lib/owlcarousel/owl.carousel.min.js"></script>
        <script src="../../assets_myboda/lib/isotope/isotope.pkgd.min.js"></script>
        <script src="../../assets_myboda/lib/lightbox/js/lightbox.min.js"></script>
        <script src="../../assets_myboda/js/opening-letter.js"></script>
        <script src="assets/js/main.js"></script>
      </div>
    </>
  );
}
