import "@/styles/custom-design-minimalista.css";
import Cronograma from "@/components/designs/elementos/Cronograma";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import Music from "@/components/designs/elementos/Music";
import Regalos from "@/components/designs/elementos/Gift";
import { formatearFecha } from "@/utils/formatearFecha";
import React, { useEffect, useState } from "react";
import {
  SvgCalendar,
  SvgCorazonCruz,
  SvgMaps,
} from "@/components/icons/SvgIcons";
import ConfirmarAsistencia from "@/components/designs/elementos/ConfirmarAsistencia";
import CustomThemes from "@/components/CustomThemes";
import { themes } from "@/libs/themes";
import Invitado from "./elementos/invitado";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faHeart } from "@fortawesome/free-solid-svg-icons";

export default function Minimalista({ datos, setYtLoad }) {
  const [currentTheme, setCurrentTheme] = useState(themes.minimalista);
  let introduction_text_1 = "";
  let introduction_text_2 = "";

  const introduction_text = datos.configs
    .filter((config) => config.nombre === "introduction_text")
    .map((config) => config.descripcion);

  if (introduction_text.length > 0) {
    const texto = introduction_text[0];

    const mitad = Math.floor(texto.length / 2);
    const ultimoEspacio = texto.lastIndexOf(" ", mitad);

    const puntoDeCorte = ultimoEspacio !== -1 ? ultimoEspacio : mitad;

    introduction_text_1 = texto.slice(0, puntoDeCorte).trim();
    introduction_text_2 = texto.slice(puntoDeCorte).trim();
  }

  const fecha_evento = formatearFecha(datos.novios.fecha_evento);

  const styles = datos.configs.filter(
    (config) => config.tipo_config === "styles"
  );

  useEffect(() => {
    const styles = datos.configs.filter(
      (config) => config.tipo_config === "styles"
    );

    if (styles && styles.length > 0) {
      const updatedTheme = {
        ...themes.minimalista,
        "--bs-primary": "#ffffff",
        "--bs-bg-primary": "#f8f8f8",
      };

      setCurrentTheme(updatedTheme);
    }
  }, [datos.configs]);

  return (
    <>
      <CustomThemes theme={currentTheme} />
      <OpeningLetter />
      <div className="container">
        <header id="header" className="">
          <div className="header-bg">
            <div className="overlay"></div>
            <div className="col-md-12 title-encab d-flex flex-column justify-content-center">
              <div className="title d-flex flex-column justify-content-center align-items-center font-family-updock">
                <p className="lh-sm">{datos.novios.nombre_novio}</p>
                <p className="lh-sm">&</p>
                <p className="lh-sm mt-5">{datos.novios.nombre_novia}</p>
              </div>
            </div>
          </div>
        </header>
        <section id="home" className="">
          <div className="row mt-6">
            <div className="col-md-2"></div>
            <div className="col-md-8">
              <img
                src="/assets/images/designs/invitaciones/minimalista/anillos.png"
                alt=""
              />
            </div>
            <div className="col-md-2"></div>
          </div>
          <div className="row mt-6">
            <div className="col-md-1"> </div>
            <div className="col-md-10 title-encab d-flex flex-column justify-content-center">
              <p className="lh-sm text-start">{introduction_text_1}</p>
              <p className="lh-sm text-end">{introduction_text_2}</p>
            </div>
            <div className="col-md-1"> </div>
          </div>
          <div className="row mt-6">
            <div className="col-md-3"></div>
            <div className="col-md-6">
              <p className="lh-sm text-center fs-1 font-family-lora">
                {datos.novios.versiculo_text}
              </p>
              <p className="lh-sm text-end fs-1 font-family-lora mt-5">
                {datos.novios.versiculo_ref}
              </p>
            </div>
            <div className="col-md-3"></div>
          </div>
        </section>
        <Invitado
          invitado={datos.invitados}
          texto_personalizado={datos.novios.texto_personalizado}
        ></Invitado>
        <section
          id="fecha"
          className={`mb-5 ${
            datos.invitados.estado === 0 && datos.invitados.estado !== 2
              ? "d-none"
              : ""
          }`}
        >
          <div className="row mt-5">
            <div className="col-md-2"></div>
            <div className="col-md-8 d-flex flex-column justify-content-center align-items-center mt-4 font-family-lora">
              <div className="fecha">
                <div className="dia-semana">{fecha_evento.diaNombre}</div>
                <div className="numeros">
                  <div className="numero izq">{fecha_evento.diaNumero}</div>
                  <div className="slash"></div>
                  <div className="numero der">{fecha_evento.mesNumero}</div>
                </div>
                <div className="anio">{fecha_evento.año}</div>
              </div>
            </div>
            <div className="col-md-2"></div>
          </div>
          <div className="row mb-5 mt-6 justify-content-center">
            <div className="col-md-12 d-flex flex-column justify-content-center align-items-center mt-4">
              <a
                className="text-decoration-none text-black text-center img-md"
                target="_blank"
                href={datos.novios.url_fecha_evento}
                title="calendar"
              >
                <SvgCalendar className="color-primary icon svg-4x" />
                <br />
                <span className="lh-sm mt-4 text-center">
                  Save &nbsp;&nbsp; the &nbsp;&nbsp; Date
                </span>
              </a>
            </div>
          </div>
          <div className="row mt-6 mb-6">
            <div className="col-md-2"></div>
            <div className="col-md-8">
              <img
                src="/assets/images/designs/invitaciones/minimalista/hojas.png"
                alt=""
              />
            </div>
            <div className="col-md-2"></div>
          </div>
          <div className="row mt-6 mb-5">
            <div className="col-md-2"></div>
            <div className="col-md-8 d-flex flex-column justify-content-center align-items-center">
              <SvgCorazonCruz className="color-black icon svg-6x bg-primary" />
              <p className="lh-sm mt-5 text-center mb-4 title-md">Ceremonia</p>
              <p className="lh-sm text-center  fs-1 font-family-lora">
                {datos.novios.dir_evento}
              </p>
              <a
                className="mt-5"
                rel="noopener noreferrer"
                target="_blank"
                href={datos.novios.url_dir_evento}
                title="ubicacion"
              >
                <SvgMaps className="color-primary icon svg-3x" />
              </a>
            </div>
            <div className="col-md-2"></div>
          </div>
        </section>
        <section
          id="addres"
          className={`mb-5 ${
            datos.invitados.estado !== 1 && datos.invitados.estado !== 2
              ? "d-none"
              : ""
          }`}
        >
          <Cronograma eventos={datos.cronograma} />
          <div className="row mt-6 mb-6">
            <div className="col-md-2"></div>
            <div className="col-md-8">
              <img
                src="/assets/images/designs/invitaciones/minimalista/hojas.png"
                alt=""
              />
            </div>
            <div className="col-md-2"></div>
          </div>
          <Regalos datos={datos.gift}></Regalos>
        </section>
        <section
          id="Confirmar"
          className={`mt-5 mb-5 ${
            datos.invitados.estado !== null && datos.invitados.estado !== 2
              ? "d-none"
              : ""
          }`}
        >
          <div className="row">
            <div className="col-md-3">
              <img
                src="/assets/images/designs/invitaciones/minimalista/flor_left.png"
                alt=""
              />
            </div>
            <div className="col-md-6 d-flex flex-column justify-content-center align-items-center">
              <p className="lh-sm mt-5 text-center text-confirmar">
                Puedes confirmar tu asistencia hasta:
              </p>
              <p className="lh-sm text-center font-family-lora text-fecha mt-5">
                {fecha_evento.texto}
              </p>
            </div>
            <div className="col-md-3">
              <img
                src="/assets/images/designs/invitaciones/minimalista/flor_rigth.png"
                alt=""
              />
            </div>
          </div>
          <ConfirmarAsistencia
            id_usuario={datos.usuario.id_usuario}
            telefono={datos.invitados.telefono}
            estadoDB={datos.invitados.estado}
            designe={datos.usuario.designe}
            cupos={datos.invitados.ctd}
            texto_confirmar_comentarios={
              datos.novios.texto_confirmar_comentarios
            }
            permitir_ninios={datos.novios.permitir_ninios}
            texto_permitir_ninios={datos.novios.texto_permitir_ninios}
          />
        </section>
        <div className="row mt-6">
          <div className="col-md-3"></div>
          <div className="col-md-5 d-flex flex-column justify-content-center align-items-center">
            <p className="lh-sm text-center">Te esperamos!!!</p>
          </div>
          <div className="col-md-4">
            <img
              src="/assets/images/designs/invitaciones/minimalista/rosa_rigth.png"
              alt=""
            />
          </div>
        </div>
      </div>
      <section id="audio">
        <Music
          link={datos.novios.url_musica}
          designe={datos.usuario.designe}
          setYtLoad={setYtLoad}
        ></Music>
      </section>

      {/* footer_start */}
      <footer className="footer mt-6 mb-6">
        <div className="row">
          <div className="copyright-text">
            <p className="copy_right text-center font-family-lora m-5">
              Todos los derechos reservados &copy;MyBoda
              <script>document.write(new Date().getFullYear());</script>{" "}
              <FontAwesomeIcon icon={faHeart} /> Desarrollado por{" "}
              <a href="https://myboda.cl" target="_blank">
                Jiempy SpA
              </a>
            </p>
          </div>
        </div>
      </footer>
      {/* footer_end */}
    </>
  );
}
