"use client";

const Invitado = ({ invitado, texto_personalizado }) => {
  const text_nombres = (invitado?.nombres || "")
    .split(",")
    .map((item) => {
      return `<p class="lh-sm text-center fs-1 fw-bold color-primary mt-3 mb-3">${item.trim()}</p>`;
    })
    .join("");

  return (
    <section id="invitado" className="mb-2">
      <div className="bg-invitado mt-3 mb-3">
        <div className="row">
          <div className="col-md-1">
          </div>
          <div className="col-md-10 d-flex flex-column justify-content-center align-items-center">
            <p className="lh-sm fs-3 text-center mt-3 mb-3">
              {texto_personalizado}
            </p>
            <div dangerouslySetInnerHTML={{ __html: text_nombres }}></div>
            <p className="lh-sm fs-3 mt-3 text-center text-invitacion mt-3 mb-3 fs-1">
              {invitado.mensaje}
            </p>
          </div>
          <div className="col-md-1">
          </div>
        </div>
      </div>
    </section>
  );
};

export default Invitado;
