"use client";
import "@/styles/music.css";
import { useEffect, useRef, useState } from "react";
import {
  faPlay,
  faPause,
  faVolumeUp,
  faVolumeMute,
} from "@fortawesome/free-solid-svg-icons";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";

export default function Music({ setYtLoad, link, designe }) {
  const playerRef = useRef(null);
  const progressBarRef = useRef(null);
  const [playing, setPlaying] = useState(false);
  const [muted, setMuted] = useState(false);
  const [duration, setDuration] = useState(0);
  const [currentTime, setCurrentTime] = useState(0);
  const [hoverTime, setHoverTime] = useState(null);
  const [localAudio, setLocalAudio] = useState(null);

  useEffect(() => {
    if (!link) {
      const musicPaths = {
        clasico: "/assets/audios/clasico.mp3",
        elegante: "/assets/audios/elegante.mp3",
        minimalista: "/assets/audios/minimalista.mp3",
        narrativo: "/assets/audios/narrativo.mp3",
        romantico: "/assets/audios/romantico.mp3",
        vintage: "/assets/audios/vintage.mp3",
      };
      setLocalAudio(musicPaths[designe] || "/assets/audios/clasico.mp3");
      setYtLoad(true);
    } else {
      setLocalAudio(null);
    }
  }, [link, designe]);

  useEffect(() => {
    if (!link) return;

    const existingScript = document.querySelector(
      'script[src="https://www.youtube.com/iframe_api"]'
    );

    if (!existingScript) {
      const script = document.createElement("script");
      script.src = "https://www.youtube.com/iframe_api";
      document.body.appendChild(script);
    }

    window.onYouTubeIframeAPIReady = () => {
      if (!window.YT) return;
      playerRef.current = new window.YT.Player("player", {
        videoId: link,
        playerVars: { controls: 0, modestbranding: 1 },
        events: {
          onReady: (event) => {
            setYtLoad(true);
            playerRef.current = event.target;
            setDuration(event.target.getDuration());
            setInterval(() => {
              setCurrentTime(event.target.getCurrentTime());
            }, 1000);
          },
          onStateChange: (event) => {
            if (event.data === YT.PlayerState.PLAYING) {
              setPlaying(true);
            } else if (
              event.data === YT.PlayerState.PAUSED ||
              event.data === YT.PlayerState.ENDED
            ) {
              setPlaying(false);
            }
          },
        },
      });
    };
  }, [link, setYtLoad]);

  useEffect(() => {
    const reproducir = () => {
      if (playerRef.current && playerRef.current.playVideo) {
        playerRef.current.playVideo();
      }
    };

    window.addEventListener("playMusic", reproducir);

    return () => {
      window.removeEventListener("playMusic", reproducir);
    };
  }, []);

  const togglePlay = () => {
    if (playerRef.current) {
      playing ? playerRef.current.pauseVideo() : playerRef.current.playVideo();
      setPlaying(!playing);
    }
  };

  const toggleMute = () => {
    if (playerRef.current) {
      muted ? playerRef.current.unMute() : playerRef.current.mute();
      setMuted(!muted);
    }
  };

  const formatTime = (time) => {
    const minutes = Math.floor(time / 60);
    const seconds = Math.floor(time % 60)
      .toString()
      .padStart(2, "0");
    return `${minutes}:${seconds}`;
  };

  const handleProgressClick = (e) => {
    if (playerRef.current && progressBarRef.current) {
      const rect = progressBarRef.current.getBoundingClientRect();
      const offsetX = e.clientX - rect.left;
      const newTime = (offsetX / rect.width) * duration;
      playerRef.current.seekTo(newTime, true);
      setCurrentTime(newTime);
    }
  };

  const handleMouseMove = (e) => {
    if (progressBarRef.current) {
      const rect = progressBarRef.current.getBoundingClientRect();
      const offsetX = e.clientX - rect.left;
      const hoverPosition = (offsetX / rect.width) * duration;
      setHoverTime(hoverPosition);
    }
  };

  const handleMouseLeave = () => {
    setHoverTime(null);
  };

  return (
    <>
      {localAudio ? (
        <div className="container py-4 text-center">
          <audio id="musicLocal" controls>
            <source src={localAudio} type="audio/mpeg" />
          </audio>
        </div>
      ) : (
        <div className="container mt-4 font-family-lora">
          <div className="ratio ratio-16x9 d-none">
            <div id="player"></div>
          </div>

          <div id="music" className="p-2 rounded">
            <div className="d-flex align-items-center justify-content-between">
              <button onClick={togglePlay} className="btn btn-default p-1">
                <FontAwesomeIcon icon={playing ? faPause : faPlay} size="1xs" />
              </button>
              <p className="text-between m-0 mx-2 p-1 text-muted fs-6">
                {formatTime(currentTime)} / {formatTime(duration)}
              </p>
              <div
                className="progress m-0 p-1"
                ref={progressBarRef}
                onClick={handleProgressClick}
                onMouseMove={handleMouseMove}
                onMouseLeave={handleMouseLeave}
              >
                <div
                  className="progress-bar bg-dark"
                  style={{ width: `${(currentTime / duration) * 100}%` }}
                ></div>
                {hoverTime !== null && (
                  <div
                    className="progress-ball"
                    style={{
                      left: `${(hoverTime / duration) * 100}%`,
                    }}
                  ></div>
                )}
              </div>

              <button onClick={toggleMute} className="btn btn-default p-1">
                <FontAwesomeIcon
                  icon={muted ? faVolumeMute : faVolumeUp}
                  size="1xs"
                />
              </button>
            </div>
          </div>
        </div>
      )}
    </>
  );
}
