

export default function Cronograma({ eventos }) {
  if (!eventos || eventos.length === 0) return null;

  return (
    <section>
      <div className="details">
        <i className="fas fa-suitcase"></i>
        <h3 className="details-heading">Cronograma</h3>
        <div className="container py-5">
          <div className="main-timeline">
            {eventos.map((evento, index) => (
              <div
                key={index}
                className={`timeline ${index % 2 === 0 ? "left" : "right"}`}
              >
                <div className="card">
                  <div className="card-body p-4">
                    <h3>{evento.nombre}</h3>
                    <p className="mb-0">{evento.descripcion}</p>
                  </div>
                </div>
              </div>
            ))}
          </div>
        </div>
      </div>
    </section>
  );
}
