import React, { useState } from "react";
import ModalBootstrap from "@/components/ModalBootstrap";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faEnvelope,
  faExchange,
  faGift,
} from "@fortawesome/free-solid-svg-icons";

export default function Regalos({ datos }) {
  const [showModal, setShowModal] = useState(false);

  if (!datos || datos.length === 0) return null;

  return (
    <>
      <div className="row">
        <div className="col-md-1"></div>
        <div className="col-md-10 d-flex flex-column justify-content-center align-items-center">
          <p className="lh-sm text-center fs-3">{datos.mensaje} </p>
          <button
            type="button"
            className="btn img-md m-4"
            onClick={() => setShowModal(true)}
            title="gift"
          >
            <img
              src="/assets/images/designs/invitaciones/minimalista/regalos.png"
              alt=""
            />
          </button>
        </div>
        <div className="col-md-1"></div>
      </div>
      <ModalBootstrap
        id="modalGift"
        title=""
        show={showModal}
        onClose={() => setShowModal(false)}
      >
        <div className="info text-left">
          <div className="row mb-2">
            <div className="col-md-2"></div>
            <div className="col-md-8">
              <img
                className="img-split"
                src="/assets/images/designs/invitaciones/minimalista/anillos.png"
                alt="anillos"
              />
            </div>
            <div className="col-md-2"></div>
          </div>
          <div className="row fs-5 mb-2">
            <div className="col-md-1"></div>
            <div className="col-md-10">
              <p className="mb-2 fw-bold">
                Tienes estas opciones para darnos un obsequio:
              </p>
              {datos.sobre === 1 && (
                <p className="mb-2">
                  <FontAwesomeIcon icon={faEnvelope} /> Con un sobre el día de
                  la boda.
                </p>
              )}
              {datos.url_gift !== null && (
                <p className="">
                  <FontAwesomeIcon icon={faGift} />{" "}
                  <a href={datos.url_gift} target="blank">
                    Ver Lista de Novios
                  </a>
                </p>
              )}
              <div className="col-md-1"></div>
            </div>
          </div>
          <div className="row fs-5">
            <div className="col-md-1"></div>
            <div className="col-md-10">
              <p className="mb-2">
                <FontAwesomeIcon icon={faExchange} /> Transferencia a la
                siguiente cuenta:
              </p>
              <p className="mb-0">
                <span className="fw-bold">Nombre:</span> {datos.nombre}
              </p>
              <p className="mb-0">
                <span className="fw-bold">Rut:</span> {datos.rut}-{datos.dvRut}
              </p>
              <p className="mb-0">
                <span className="fw-bold">Email:</span>
                {datos.email}
              </p>
              <p className="mb-0">
                <span className="fw-bold">Banco:</span> {datos.banco}
              </p>
              <p className="mb-0">
                <span className="fw-bold">Tipo Cuenta:</span> {datos.tipoCuenta}
              </p>
              <p className="mb-0">
                <span className="fw-bold">Numero Cuenta:</span>{" "}
                {datos.numeroCuenta}
              </p>
            </div>
            <div className="col-md-1"></div>
          </div>
        </div>
      </ModalBootstrap>
    </>
  );
}
