import React from "react";
import "@/styles/custom-cronograma.css";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faHandshakeSimple,
  faCameraRetro,
  faGift,
} from "@fortawesome/free-solid-svg-icons";

import {
  SvgAnillo,
  SvgCena,
  SvgBrindis,
  SvgCars,
  SvgPastel,
  SvgDance,
  SvgParty,
  SvgNovia,
  SvgBeso,
} from "@/components/icons/SvgIcons";

const SvgMap = {
  svgAnillo: SvgAnillo,
  svgCena: SvgCena,
  svgBrindis: SvgBrindis,
  svgCars: SvgCars,
  svgPastel: SvgPastel,
  svgDance: SvgDance,
  svgParty: SvgParty,
  svgNovia: SvgNovia,
  svgBeso: SvgBeso,
};

const iconMap = {
  faHandshakeSimple,
  faCameraRetro,
  faGift,
};

export default function Cronograma({ eventos }) {
  if (!eventos || eventos.length === 0) return null;

  return (
    <section id="cronograma d-none" className="mt-5 mx-5 mb-5 font-family-lora">
      <div className="row mt-6 mb-6">
        <div className="col-md-2"></div>
        <div className="col-md-8">
          <img
            src="/assets/images/designs/invitaciones/minimalista/hojas.png"
            alt=""
          />
        </div>
        <div className="col-md-2"></div>
      </div>
      <div className="row mb-5">
        <div className="col-md-1"></div>
        <div className="col-md-10 d-flex flex-column justify-content-center align-items-center">
          <p className="lh-sm mt-5 text-center mb-4 title-md">Cronograma</p>
        </div>
        <div className="col-md-1"></div>
      </div>
      <div className="timeline">
        {eventos.map((evento, index) => {
          const isFontAwesome = evento.icono in iconMap;
          const isSvgIcon = evento.icono in SvgMap;
          return (
            <div
              key={index}
              className={`event ${index % 2 === 0 ? "left" : "right"}`}
            >
              <div className="content">
                <div className="text-center fs-1">
                  {isFontAwesome ? (
                    <FontAwesomeIcon
                      icon={iconMap[evento.icono]}
                      className="text icon"
                      size="2x"
                    />
                  ) : isSvgIcon ? (
                    React.createElement(SvgMap[evento.icono], {
                      className: `text icon ${
                        evento.icono === "svgCars" ? "svg-4x" : "svg-2x"
                      }`,
                    })
                  ) : null}
                  <div className="text fs-1">{evento.nombre}</div>
                  <div className="text time fs-3">{evento.hora} hrs</div>
                </div>
              </div>
            </div>
          );
        })}
      </div>
    </section>
  );
}
