"use client";

import { useEffect, useState } from "react";

const parseDate = (dateStr) => {
  const [day, month, year] = dateStr.split("/").map(Number);
  return new Date(year, month - 1, day); 
};

const Countdown = ({ fecha_evento }) => {
  const calculateTimeLeft = () => {
    const target = parseDate(fecha_evento);
    const now = new Date();
    const difference = target - now;

    if (difference <= 0) {
      return { days: 0, hours: 0, minutes: 0, seconds: 0 };
    }

    return {
      days: Math.floor(difference / (1000 * 60 * 60 * 24)),
      hours: Math.floor((difference / (1000 * 60 * 60)) % 24),
      minutes: Math.floor((difference / 1000 / 60) % 60),
      seconds: Math.floor((difference / 1000) % 60),
    };
  };

  const [timeLeft, setTimeLeft] = useState(calculateTimeLeft());

  useEffect(() => {
    const timer = setInterval(() => {
      setTimeLeft(calculateTimeLeft());
    }, 100);

    return () => clearInterval(timer);
  }, [fecha_evento]);

  return (
    <div id="clock" className="countdown_area counter_bg ">
      <div className="countdown_wrap d-flex">
        <div className="single_countdown">
          <h3>{timeLeft.days}</h3>
          <span>Days</span>
        </div>
        <div className="single_countdown">
          <h3>{timeLeft.hours}</h3>
          <span>Hours</span>
        </div>
        <div className="single_countdown">
          <h3>{timeLeft.minutes}</h3>
          <span>Minutes</span>
        </div>
        <div className="single_countdown">
          <h3>{timeLeft.seconds}</h3>
          <span>Seconds</span>
        </div>
      </div>
    </div>
  );
};

export default Countdown;
