"use client";
import "@/styles/custom-confirmarAsistencia.css";
import ModalBootstrap from "@/components/ModalBootstrap";
import Loader_basico from "@/components/Loader_basico";
import { useState, useEffect } from "react";
import { api } from "@/libs/apiClient";

export default function ConfirmarAsistencia({
  telefono,
  id_usuario,
  estadoDB,
  designe,
  cupos,
  texto_confirmar_comentarios,
  permitir_ninios,
  texto_permitir_ninios,
}) {
  const [enviando, setEnviando] = useState(false);
  const [showModal, setShowModal] = useState(false);
  const [estadoPendiente, setestadoPendiente] = useState(null);
  const [estadoFinal, setEstadoFinal] = useState(null);
  const [formData, setFormData] = useState({
    id_usuario: id_usuario,
    telefono: telefono,
    adultos: cupos === 1 ? "1" : "0",
    ninios: "0",
    comentarios: "",
    cupos: cupos,
  });

  useEffect(() => {
    if (estadoFinal === 1) {
      document.getElementById("fecha")?.classList.remove("d-none");
      document.getElementById("addres")?.classList.remove("d-none");
      document.getElementById("confirmar")?.classList.add("d-none");
    } else if (estadoFinal === 0) {
      document.getElementById("fecha")?.classList.add("d-none");
      document.getElementById("addres")?.classList.add("d-none");
      document.getElementById("confirmar")?.classList.add("d-none");
    }
  }, [estadoFinal]);

  const enviarestado = async (estado) => {
    try {
      setEnviando(true);

      if (estadoDB === 2) {
        return null;
      }

      const data = await api.post("/invitados/confirmarAsistencia", {
        id_usuario: parseInt(id_usuario),
        telefono: parseInt(telefono),
        estado: parseInt(estado),
        adultos: parseInt(formData.adultos),
        ninios: parseInt(formData.ninios),
        obs: formData.comentarios,
      });

      if (data) {
        setEstadoFinal(estado);
        setShowModal(false);
      } else {
        console.error(data);
      }
    } catch (err) {
      console.error(err);
      alert("Error de red. Intenta nuevamente.");
    } finally {
      setEnviando(false);
    }
  };

  const abrirModalConfirmacion = (estado) => {
    setestadoPendiente(estado);
    setShowModal(true);
  };

  const confirmarEnvio = () => {
    setShowModal(false);
    enviarestado(estadoPendiente);
    setestadoPendiente(null);
  };

  const handleChange = (e) => {
    const { name, value } = e.target;

    if (name !== "adultos" && name !== "ninios") {
      setFormData((prevFormData) => ({
        ...prevFormData,
        [name]: value,
      }));
    } else {
      const numericValue = value.replace(/\D/g, "");

      setFormData((prevFormData) => {
        const total = parseInt(cupos) || 0;
        const adultos = parseInt(prevFormData.adultos) || 0;
        const ninios = parseInt(prevFormData.ninios) || 0;
        const currenttotal = Math.max(0, total - adultos - ninios);
        const previousValue = parseInt(prevFormData[name]) || 0;
        const incomingValue = parseInt(numericValue) || 0;

        const isTryingToIncrease = incomingValue > previousValue;
        const isTargetRestricted = ["adultos", "ninios"].includes(name);

        if (currenttotal <= 0 && isTryingToIncrease && isTargetRestricted) {
          return prevFormData;
        }

        const updatedFormData = {
          ...prevFormData,
          [name]: numericValue,
        };

        const newAdultos = parseInt(updatedFormData.adultos) || 0;
        const newNinios = parseInt(updatedFormData.ninios) || 0;

        updatedFormData.cupos = Math.max(0, total - newAdultos - newNinios);

        return updatedFormData;
      });
    }
  };

  return (
    <>
      {enviando && <Loader_basico />}

      {designe === "minimalista" ? (
        <section>
          <div className="row mt-6 mb-5">
            <div className="col-md-2"></div>

            <div className="col-md-4 d-flex flex-column justify-content-center align-items-center">
              <img
                className="img-md mb-3"
                src="/assets/images/designs/invitaciones/minimalista/corazon_triste.png"
                alt=""
              />
              <button
                type="button"
                className="btn-rechazar btn btn-success btn-scuare"
                onClick={() => abrirModalConfirmacion(0)}
                disabled={enviando}
              >
                <span className="font-family-lora">No podré asistir</span>
              </button>
            </div>

            <div className="col-md-4 d-flex flex-column justify-content-center align-items-center">
              <img
                className="img-md mb-3"
                src="/assets/images/designs/invitaciones/minimalista/corazon_feliz.png"
                alt=""
              />
              <button
                type="button"
                className="btn btn-success btn-scuare"
                onClick={() => abrirModalConfirmacion(1)}
                disabled={enviando}
              >
                <span className="font-family-lora">Confirmo mi asistencia</span>
              </button>
            </div>

            <div className="col-md-2"></div>
          </div>
        </section>
      ) : designe === "vintage" ? (
        <>
          <div className="row">
            <div className="col-xl-12">
              <button
                type="button"
                className="boxed_btn3 my-4"
                onClick={() => abrirModalConfirmacion(1)}
                disabled={enviando}
              >
                Confirmo
              </button>
              <button
                type="button"
                className="boxed_btn3 my-4"
                onClick={() => abrirModalConfirmacion(0)}
                disabled={enviando}
              >
                No podré Asitir
              </button>
            </div>
          </div>
        </>
      ) : (
        <label>otro</label>
      )}

      <ModalBootstrap
        id="confirmModal"
        show={showModal}
        onClose={() => setShowModal(false)}
        title=""
        footerContent={
          <>
            <button
              type="button"
              className="btn btn-danger btn-sm fs-4"
              onClick={() => setShowModal(false)}
            >
              Cancelar
            </button>
            <button
              type="button"
              className="btn btn-success btn-sm fs-4"
              onClick={confirmarEnvio}
              disabled={enviando}
            >
              {estadoPendiente === 1
                ? "Confirmo Asistencia"
                : "No podré asistir"}
            </button>
          </>
        }
      >
        <div className="text-center">
          <img
            className="img-50 mb-4 "
            src="/assets/images/designs/invitaciones/minimalista/anillos.png"
            alt=""
          />
          <h4 className="mb-3">
            {estadoPendiente === 1
              ? "¿Confirmas tu asistencia?"
              : "¿Estás seguro de que no podrás asistir?"}
          </h4>
          {estadoPendiente === 1 && permitir_ninios == 0 && (
            <div className="row col-md-12 py-2">
              <div className="col-md-12">
                <label className="">{texto_permitir_ninios}</label>
              </div>
            </div>
          )}
          {estadoPendiente === 1 && cupos > 1 && (
            <>
              <div className="row col-md-12 py-2">
                <div className="col-md-3"></div>
                <div className="col-md-3">
                  <label className="fw-bold">Adultos</label>
                </div>
                <div className="col-md-3">
                  <div className="form-group">
                    <input
                      type="number"
                      className="form-control"
                      name="adultos"
                      id="aduntos"
                      value={formData.adultos}
                      min="0"
                      onChange={handleChange}
                    />
                  </div>
                </div>
              </div>
              {estadoPendiente === 1 && permitir_ninios == 1 && (
                <div className="row col-md-12 py-2">
                  <div className="col-md-3"></div>
                  <div className="col-md-3">
                    <label className="fw-bold">Niños</label>
                  </div>
                  <div className="col-md-3">
                    <div className="form-group">
                      <input
                        type="number"
                        className="form-control"
                        name="ninios"
                        id="ninios"
                        value={formData.ninios}
                        min="0"
                        onChange={handleChange}
                      />
                    </div>
                  </div>
                </div>
              )}
              <div className="row col-md-12 py-2">
                <div className="col-md-12">
                  <label className="fw-bold">
                    Total disponibles: {formData.cupos}
                  </label>
                </div>
              </div>
              <div className="row col-md-12 py-2">
                <div className="col-md-12 py-3">
                  <label className="fw-bold">
                    {texto_confirmar_comentarios}
                  </label>
                </div>
                <div className="col-md-1"></div>
                <div className="col-md-10">
                  <div className="form-group">
                    <textarea
                      className="form-control"
                      name="comentarios"
                      id="comentarios"
                      value={formData.comentarios}
                      onChange={handleChange}
                    ></textarea>
                  </div>
                </div>
              </div>
            </>
          )}
        </div>
      </ModalBootstrap>
    </>
  );
}
