import Cronograma from "@/components/designs/elementos/Cronograma";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import { formatearFecha } from "@/utils/formatearFecha";
import { useEffect } from "react";
import "@/styles/custom-design-elegante-Bootstrap.css";
import "@/styles/custom-design-elegante.css";
import Music from "./elementos/Music";
import CustomThemes from "../CustomThemes";
import { themes } from "@/libs/themes";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faArrowUp,
  faDungeon,
  faHeart,
  faMenorah,
  faPhotoVideo,
  faPlus,
  faRing,
} from "@fortawesome/free-solid-svg-icons";
import {
  faFacebookF,
  faInstagram,
  faLinkedinIn,
  faTwitter,
} from "@fortawesome/free-brands-svg-icons";

export default function clasico({ datos, setYtLoad }) {
  const fecha_evento = formatearFecha(datos.novios.fecha_evento);
  const fecha_limite = formatearFecha(datos.novios.fecha_limite);

  return (
    <>
      <CustomThemes theme={themes.elegante} />
      <OpeningLetter />
      <div data-bs-spy="scroll" data-bs-target="#navBar" id="Home">
        {/* Navbar start */}
        <div className="container-fluid sticky-top px-0">
          <div className="container-fluid">
            <div className="container px-0">
              <nav className="navbar navbar-light navbar-expand-xl" id="navBar">
                <a href="index.html" className="navbar-brand">
                  <h4 className="text-primary display-6 fw-bold mb-0">
                    Señor<strong className="text-secondary">&</strong>Señora
                  </h4>
                </a>
                <button
                  className="navbar-toggler py-2 px-3"
                  type="button"
                  data-bs-toggle="collapse"
                  data-bs-target="#navbarCollapse"
                  title="btn"
                >
                  <span className="fa fa-bars text-primary"></span>
                </button>
                <div
                  className="collapse navbar-collapse py-3"
                  id="navbarCollapse"
                >
                  <div className="navbar-nav mx-auto border-top">
                    <a href="#Home" className="nav-item nav-link active">
                      INICIO
                    </a>
                    <a href="#About" className="nav-item nav-link">
                      Evento
                    </a>
                    <a href="#Story" className="nav-item nav-link">
                      HISTORIA
                    </a>
                    <a href="#Rsvp" className="nav-item nav-link">
                      CONFIRMAR
                    </a>
                    <a href="#Gallery" className="nav-item nav-link">
                      GALERIA
                    </a>
                  </div>
                </div>
              </nav>
            </div>
          </div>
        </div>
        {/* Navbar End */}

        {/* Carousel Start */}
        <div className="container-fluid carousel-header px-0">
          <div
            id="carouselId"
            className="carousel slide"
            data-bs-ride="carousel"
          >
            <ol className="carousel-indicators">
              <li
                data-bs-target="#carouselId"
                data-bs-slide-to="0"
                className="active"
              ></li>
              <li data-bs-target="#carouselId" data-bs-slide-to="1"></li>
              <li data-bs-target="#carouselId" data-bs-slide-to="2"></li>
            </ol>
            <div
              className="carousel-inner"
              role="listbox"
              aria-label="carousel"
            >
              <div className="carousel-item active">
                <img
                  src="/assets/images/designs/invitaciones/elegante/carousel-1.jpg"
                  className="img-fluid"
                  alt="Image"
                />
                <div className="carousel-caption">
                  <div className="p-3 mx-auto animated zoomIn">
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-4">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        ¡NOS VAMOS A CASAR!
                      </h4>
                    </div>
                    <h1 className="display-1 text-capitalize text-white mb-3">
                      Evelyn{" "}
                      <FontAwesomeIcon
                        icon={faHeart}
                        className="text-primary"
                      />{" "}
                      Anthony
                    </h1>
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-5">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        28 de Junio de 2024
                      </h4>
                    </div>
                    <div className="d-flex align-items-center justify-content-center">
                      <a
                        className="btn btn-primary btn-primary-outline-0 py-3 px-5"
                        href="#"
                      >
                        Confirmar mi asistencia
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <div className="carousel-item">
                <img
                  src="/assets/images/designs/invitaciones/elegante/carousel-2.jpg"
                  className="img-fluid"
                  alt="Image"
                />
                <div className="carousel-caption">
                  <div className="p-3 mx-auto animated zoomIn">
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-5">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        ¡NOS VAMOS A CASAR!
                      </h4>
                    </div>
                    <h1 className="display-1 text-capitalize text-white mb-3">
                      Evelyn{" "}
                      <FontAwesomeIcon
                        icon={faHeart}
                        className="text-primary"
                      />{" "}
                      Anthony
                    </h1>
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-4">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        28 de Junio de 2024
                      </h4>
                    </div>
                    <div className="d-flex align-items-center justify-content-center">
                      <a
                        className="btn btn-primary btn-primary-outline-0 py-3 px-5"
                        href="#"
                      >
                        Confirmar mi asistencia
                      </a>
                    </div>
                  </div>
                </div>
              </div>
              <div className="carousel-item">
                <img
                  src="/assets/images/designs/invitaciones/elegante/carousel-3.png"
                  className="img-fluid bg-secondary"
                  alt="Image"
                />
                <div className="carousel-caption">
                  <div className="p-3 mx-auto animated zoomIn">
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-4">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        ¡NOS VAMOS A CASAR!
                      </h4>
                    </div>
                    <h1 className="display-1 text-capitalize text-white mb-3">
                      Evelyn{" "}
                      <FontAwesomeIcon
                        icon={faHeart}
                        className="text-primary"
                      />{" "}
                      Anthony
                    </h1>
                    <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-4">
                      <h4 className="text-white text-uppercase fw-bold mb-0">
                        28 de Junio de 2024
                      </h4>
                    </div>
                    <div className="d-flex align-items-center justify-content-center">
                      <a
                        className="btn btn-primary btn-primary-outline-0 py-3 px-5"
                        href="#"
                      >
                        Confirmar mi asistencia
                      </a>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <button
              className="carousel-control-prev"
              type="button"
              data-bs-target="#carouselId"
              data-bs-slide="prev"
            >
              <span
                className="carousel-control-prev-icon"
                aria-hidden="true"
              ></span>
              <span className="visually-hidden">Prev</span>
            </button>
            <button
              className="carousel-control-next"
              type="button"
              data-bs-target="#carouselId"
              data-bs-slide="next"
            >
              <span
                className="carousel-control-next-icon"
                aria-hidden="true"
              ></span>
              <span className="visually-hidden">Next</span>
            </button>
          </div>
        </div>
        {/* Carousel End */}

        {/* Hello! Start */}
        <div className="container-fluid position-relative py-5" id="About">
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container position-relative py-5">
            <div
              className="mx-auto text-center mb-5 wow fadeInUp"
              data-wow-delay="0.1s"
            >
              <h1 className="text-primary display-1">Hola!</h1>
              <h4 className="text-dark mb-0">
                Te invitamos a nuestro matrimonio!
              </h4>
            </div>
            <div className="row">
              <div className="col-lg-12">
                <div className="row g-4 align-items-center">
                  <div className="col-lg-5 wow fadeInUp" data-wow-delay="0.3s">
                    <div className="d-flex">
                      <div className="text-end my-auto pe-4">
                        <h3 className="text-primary mb-3">Evelyn</h3>
                        <p className="text-dark mb-0">
                          Información de la novia
                        </p>
                      </div>
                      <img
                        src="/assets/images/designs/invitaciones/elegante/bride.jpg"
                        className="img-fluid img-border"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="col-lg-2 wow fadeIn" data-wow-delay="0.5s">
                    <div className="d-flex align-items-center justify-content-center">
                      <FontAwesomeIcon
                        icon={faHeart}
                        size="5"
                        className="text-primary"
                      />
                    </div>
                  </div>
                  <div className="col-lg-5 wow fadeInUp" data-wow-delay="0.3s">
                    <div className="d-flex">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/Groom.jpg"
                        className="img-fluid img-border"
                        alt="Image"
                      />
                      <div className="my-auto ps-4">
                        <h3 className="text-primary mb-3">Anthony</h3>
                        <p className="text-dark mb-0">Información del novio</p>
                      </div>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Hello! End */}

        {/* Story Start */}
        <div
          className="container-fluid story position-relative py-5"
          id="Story"
        >
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container position-relative py-5">
            <div
              className="text-center mb-5 wow fadeInUp"
              data-wow-delay="0.1s"
            >
              <h5 className="text-uppercase text-primary fw-bold mb-4">
                Nuestra historia de amor
              </h5>
            </div>
            <div className="story-timeline">
              <div className="row wow fadeInUp" data-wow-delay="0.2s">
                <div className="col-md-6 text-end border-0 border-top border-end border-secondary p-4">
                  <div className="d-inline-flex align-items-center h-100">
                    <img
                      src="/assets/images/designs/invitaciones/elegante/story-1.jpg"
                      className="img-fluid w-100 img-border"
                      alt="Image"
                    />
                  </div>
                </div>
                <div className="col-md-6 border-start border-top border-secondary p-4 pe-0">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                    <h4 className="mb-2 text-dark">Primer encuentro</h4>
                    <p className="text-uppercase text-primary mb-2">
                      01 Enero 2050
                    </p>
                    <p className="m-0 fs-5">
                      Descripción del primer encuentro.
                    </p>
                  </div>
                </div>
              </div>
              <div
                className="row flex-column-reverse flex-md-row wow fadeInUp"
                data-wow-delay="0.3s"
              >
                <div className="col-md-6 text-end border-end border-top border-secondary p-4 ps-0">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                    <h4 className="text-dark mb-2">Primera Cita</h4>
                    <p className="text-uppercase text-primary mb-2">
                      10 Enero 2050
                    </p>
                    <p className="m-0 fs-5">La primera cita.</p>
                  </div>
                </div>
                <div className="col-md-6 border-start border-top border-secondary p-4">
                  <div className="d-inline-flex align-items-center h-100">
                    <img
                      src="/assets/images/designs/invitaciones/elegante/story-2.jpg"
                      className="img-fluid w-100 img-border"
                      alt="Image"
                    />
                  </div>
                </div>
              </div>
              <div className="row wow fadeInUp" data-wow-delay="0.4s">
                <div className="col-md-6 text-end border-end border-top border-secondary p-4 ps-0">
                  <div className="d-inline-flex align-items-center h-100">
                    <img
                      src="/assets/images/designs/invitaciones/elegante/story-3.jpg"
                      className="img-fluid w-100 img-border"
                      alt="Image"
                    />
                  </div>
                </div>
                <div className="col-md-6 border-start border-top border-secondary p-4 pe-0">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                    <h4 className="text-dark mb-2">Propuesta de matrimonio</h4>
                    <p className="text-uppercase text-primary mb-2">
                      01 Diciembre 2051
                    </p>
                    <p className="m-0 fs-5">Como fue?.</p>
                  </div>
                </div>
              </div>
              <div
                className="row flex-column-reverse flex-md-row wow fadeInUp"
                data-wow-delay="0.5s"
              >
                <div className="col-md-6 text-end border border-start-0 border-secondary p-4 ps-0">
                  <div className="h-100 d-flex flex-column justify-content-center bg-secondary p-4">
                    <h4 className="text-dark mb-2">Compromiso</h4>
                    <p className="text-uppercase text-primary mb-2">
                      01 Enero 2052
                    </p>
                    <p className="m-0 fs-5">Como y donde se comprometieron.</p>
                  </div>
                </div>
                <div className="col-md-6 border border-end-0 border-secondary p-4">
                  <div className="d-inline-flex align-items-center h-100">
                    <img
                      src="/assets/images/designs/invitaciones/elegante/story-4.jpg"
                      className="img-fluid w-100 img-border"
                      alt="Image"
                    />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Story End */}

        {/*-  Rsvp */}
        <div
          className="container-fluid -date-bg position-relative py-5"
          id="Rsvp"
        >
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container py-5 wow zoomIn" data-wow-delay="0.1s">
            <div className="-date text-center bg-light p-5">
              <div className="-date-content">
                <div className="d-inline-block border-end-0 border-start-0 border-secondary p-2 mb-4">
                  <h4 className="text-dark text-uppercase fw-bold mb-0">
                    ¡NOS VAMOS A CASAR!
                  </h4>
                </div>
                <h1 className="text-dark fs-5">
                  Estas invitado a nuestro Matrimonio!
                </h1>
                <div className="d-flex align-items-center justify-content-center mb-5">
                  <div className="text-dark fs-2 me-4">
                    <div className="mt-5">
                      <div className="row g-5 justify-content-center text-center">
                        <div
                          className="col-md-4 wow fadeIn"
                          data-wow-delay="0.3s"
                        >
                          <div className="p-4 border-secondary">
                            <h4>Cuando?</h4>
                            <p className="mb-0 text-dark">
                              28 de Junio de 2024.
                            </p>
                          </div>
                        </div>
                        <div
                          className="col-md-4 wow fadeIn"
                          data-wow-delay="0.5s"
                        >
                          <div className="p-4 border-secondary">
                            <h4>Donde?</h4>
                            <p className="mb-0 text-dark">
                              Calle numero, 123 de la Ciudad y Pais.
                            </p>
                          </div>
                        </div>
                      </div>
                    </div>
                  </div>
                </div>
                <button
                  className="btn btn-primary btn-primary-outline-0 p-4 m-4"
                  type="button"
                >
                  No pordré asistir
                </button>
                <button
                  className="btn btn-success btn-primary-outline-0 p-4 m-4"
                  type="button"
                >
                  Confirmo mi asistencia
                </button>
              </div>
            </div>
          </div>
        </div>
        {/*  Rsvp */}

        {/*  Timeline start */}
        <div
          className="container-fluid -timeline bg-secondary position-relative overflow-hidden py-5"
          id="Timeline"
        >
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/attendance-bg.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/attendance-bg.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container py-5">
            <div className="text-center mb-5">
              <h1 className="display-4 text-white">Cronograma</h1>
            </div>
            <div className="position-relative -content">
              <div className="row g-4">
                <div className="col-6 col-md-6 col-xl-3 border border-bottom-0">
                  <div
                    className="text-center p-3 wow fadeIn"
                    data-wow-delay="0.1s"
                  >
                    <div className="mb-4 p-3 d-inline-flex">
                      <FontAwesomeIcon
                        icon={faMenorah}
                        size="3"
                        className="text-primary"
                      />
                    </div>
                    <p className="text-primary">10:00AM - 11:00AM</p>
                    <h3 className="text-dark">Cena</h3>
                    <p className="text-dark">Breve descripción</p>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-xl-3 border border-top-0 border-start-0">
                  <div
                    className="text-center p-3 wow fadeIn"
                    data-wow-delay="0.3s"
                  >
                    <div className="mb-4 p-3 d-inline-flex">
                      <FontAwesomeIcon
                        icon={faPhotoVideo}
                        size="3"
                        className="text-primary"
                      />
                    </div>
                    <p className="text-primary">10:00AM - 11:00AM</p>
                    <h3 className="text-dark">Sesion de fotos</h3>
                    <p className="text-dark">Breve descripción</p>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-xl-3 border border-bottom-0 border-end-0">
                  <div
                    className="text-center p-3 wow fadeIn"
                    data-wow-delay="0.5s"
                  >
                    <div className="mb-4 p-3 d-inline-flex">
                      <FontAwesomeIcon
                        icon={faDungeon}
                        size="3"
                        className="text-primary"
                      />
                    </div>
                    <p className="text-primary">10:00AM - 11:00AM</p>
                    <h3 className="text-dark">Recepción</h3>
                    <p className="text-dark">Breve descripción</p>
                  </div>
                </div>
                <div className="col-6 col-md-6 col-xl-3 border border-top-0">
                  <div
                    className="text-center p-3 wow fadeIn"
                    data-wow-delay="0.7s"
                  >
                    <div className="mb-4 p-3 d-inline-flex">
                      <FontAwesomeIcon
                        icon={faRing}
                        size="3"
                        className="text-primary"
                      />
                    </div>
                    <p className="text-primary">10:00AM - 11:00AM</p>
                    <h3 className="text-dark">Ceremonia</h3>
                    <p className="text-dark">Breve descripción</p>
                  </div>
                </div>
              </div>
              <div className="position-absolute heart-circle ">
                <div className="border border-2 border-primary rounded-circle p-1 bg-secondary"></div>
              </div>
              <div className="position-absolute heart-circle">
                <div className="border border-2 border-primary rounded-circle p-1 bg-secondary"></div>
              </div>
            </div>
          </div>
        </div>
        {/*  Timeline End */}

        {/* Gallery Start */}
        <div
          className="container-fluid gallery position-relative py-5"
          id="Gallery"
        >
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container position-relative py-5">
            <div
              className="text-center mx-auto pb-5 wow fadeInUp"
              data-wow-delay="0.1s"
            >
              <h1 className="display-2 text-dark">Galeria</h1>
              <p className="fs-5 text-dark">Breve descripción</p>
            </div>
            <div className="row g-4">
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.2s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-1.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-1.jpg"
                        data-lightbox="Gallery-1"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>En la playa</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.4s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-2.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-2.jpg"
                        data-lightbox="Gallery-2"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.6s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-3.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-3.jpg"
                        data-lightbox="Gallery-3"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.8s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-4.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-4.jpg"
                        data-lightbox="Gallery-4"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.2s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-5.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-5.jpg"
                        data-lightbox="Gallery-5"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.4s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-6.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-6.jpg"
                        data-lightbox="Gallery-6"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.6s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-7.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-7.jpg"
                        data-lightbox="Gallery-7"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-4 col-xl-3 wow fadeInUp"
                data-wow-delay="0.8s"
              >
                <div className="gallery-item">
                  <div className="gallery-img">
                    <img
                      className="img-fluid w-100"
                      src="/assets/images/designs/invitaciones/elegante/gallery-8.jpg"
                      alt="Image"
                    />
                    <div className="hover-style"></div>
                    <div className="search-icon">
                      <a
                        href="/assets/images/designs/invitaciones/elegante/gallery-8.jpg"
                        data-lightbox="Gallery-8"
                        className="my-auto"
                        title="galeria"
                      >
                        <FontAwesomeIcon
                          icon={faPlus}
                          size="3"
                          className="btn btn-primary-outline-0 p-3"
                        />
                      </a>
                    </div>
                  </div>
                  <div className="gallery-overlay bg-light border-secondary border-top-0 p-4">
                    <h5>El lugar</h5>
                    <p className="text-dark mb-0">28 de Junio de 2024</p>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Gallery end */}

        {/*- Bridesmaids & Groomsmen start */}
        <div className="container-fluid team position-relative py-5">
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="position-absolute">
            <img
              src="/assets/images/designs/invitaciones/elegante/tamp-bg-1.png"
              className="img-fluid"
              alt="Image"
            />
          </div>
          <div className="container py-5">
            <div
              className="mb-5 text-center mx-auto wow fadeInUp"
              data-wow-delay="0.1s"
            >
              <h1 className="display-2 text-dark">
                Damas de honor & Padrinos de boda
              </h1>
              <p className="fs-5 text-dark">Breve descripción </p>
            </div>
            <div className="row g-4">
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.2s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/bridesmaid-1.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">Amelia Alex</h5>
                      <h5 className="text-white fs-5 mb-0">Dama de honor</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.4s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/bridesmaid-team-2.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">Amelia Alex</h5>
                      <h5 className="text-white fs-5 mb-0">Dama de honor</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.6s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/bridesmaid-3.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">Amelia Alex</h5>
                      <h5 className="text-white fs-5 mb-0">Dama de honor</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.8s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/bridesmaid-4.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">Amelia Alex</h5>
                      <h5 className="text-white fs-5 mb-0">Dama de honor</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.2s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/Groomsmen-1.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">David John</h5>
                      <h5 className="text-white fs-5 mb-0">Padrino</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.4s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/Groomsmen-2.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">David John</h5>
                      <h5 className="text-white fs-5 mb-0">Padrino</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.6s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/Groomsmen-3.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">David John</h5>
                      <h5 className="text-white fs-5 mb-0">Padrino</h5>
                    </div>
                  </div>
                </div>
              </div>
              <div
                className="col-md-6 col-lg-6 col-xl-3 wow fadeInUp"
                data-wow-delay="0.8s"
              >
                <div className="team-item">
                  <div className="team-img">
                    <div className="team-img-main">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/Groomsmen-4.png"
                        className="img-fluid w-100"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                    <div className="team-img-bg position-absolute">
                      <img
                        src="/assets/images/designs/invitaciones/elegante/team-1-bg.png"
                        className="img-fluid"
                        alt="Image"
                      />
                    </div>
                  </div>
                  <div className="team-content">
                    <div className="d-flex flex-column p-4">
                      <h5 className="text-white display-6 mb-1">David John</h5>
                      <h5 className="text-white fs-5 mb-0">Padrino</h5>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        {/* Bridesmaids & Groomsmen End */}
        <section id="audio">
          <Music
            link={datos.novios.url_musica}
            designe={datos.usuario.designe}
            setYtLoad={setYtLoad}
          ></Music>
        </section>
        <div
          className="container-fluid footer py-5 wow fadeIn"
          data-wow-delay="0.1s"
        >
          <div className="container py-5">
            <div className="row g-5 justify-content-center">
              <div className="col-lg-4 text-center">
                <div className="footer-item">
                  <h4 className="mb-4 text-white">
                    Evelyn<strong className="text-primary">&</strong>Antony
                  </h4>
                  <p className="text-white">Breve descripción.</p>
                  <div className="btn-link d-flex justify-content-center">
                    <a
                      href="#"
                      className="btn btn-md-square btn-light btn-light-outline-0 me-2"
                      title="galeria"
                    >
                      <FontAwesomeIcon icon={faFacebookF} />
                    </a>
                    <a
                      href="#"
                      className="btn btn-md-square btn-light btn-light-outline-0 me-2"
                      title="galeria"
                    >
                      <FontAwesomeIcon icon={faTwitter} />
                    </a>
                    <a
                      href="#"
                      className="btn btn-md-square btn-light btn-light-outline-0 me-2"
                      title="galeria"
                    >
                      <FontAwesomeIcon icon={faInstagram} />
                    </a>
                    <a
                      href="#"
                      className="btn btn-md-square btn-light btn-light-outline-0 me-0"
                      title="galeria"
                    >
                      <FontAwesomeIcon icon={faLinkedinIn} />
                    </a>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>

        {/* footer_start */}
        <footer className="footer">
          <div className="copy-right_text">
            <div className="container">
              <div className="footer_border"></div>
              <div className="row">
                <div className="col-xl-12">
                  <p className="copy_right text-center m-5">
                    {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
                    Todos los derechos reservados &copy;MyBoda
                    <script>
                      document.write(new Date().getFullYear());
                    </script>{" "}
                    <FontAwesomeIcon icon={faHeart} /> Desarrollado por{" "}
                   <a href="https://myboda.cl" target="_blank">
                      Jiempy SpA
                    </a>
                    {/* Link back to Colorlib can't be removed. Template is licensed under CC BY 3.0. */}
                  </p>
                </div>
              </div>
            </div>
          </div>
        </footer>
        {/* footer_end */}

        {/* Back to Top */}
        <a
          href="#"
          className="btn btn-primary btn-primary-outline-0 btn-md-square back-to-top"
          title="galeria"
        >
          <FontAwesomeIcon icon={faArrowUp} />
        </a>

        {/* JavaScript Libraries */}
        <script src="../../assets_myboda/js/jquery.min.js"></script>
        <script src="../../assets_myboda/js/bootstrap.bundle.min.js"></script>
        <script src="../../assets_myboda/lib/wow/wow.min.js"></script>
        <script src="../../assets_myboda/lib/easing/easing.min.js"></script>
        <script src="../../assets_myboda/lib/waypoints/waypoints.min.js"></script>
        <script src="../../assets_myboda/lib/lightbox/js/lightbox.min.js"></script>
        <script src="../../assets_myboda/js/opening-letter.js"></script>
        <script src="assets/js/main.js"></script>
      </div>
    </>
  );
}
