import Cronograma from "@/components/designs/elementos/Cronograma";
import OpeningLetter from "@/components/designs/elementos/OpeningLetter";
import { formatearFecha } from "@/utils/formatearFecha";
import { useEffect } from "react";
import "@/styles/custom-design-clasico.css";
import CustomThemes from "../CustomThemes";
import { themes } from "@/libs/themes";
import Music from "./elementos/Music";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faCalendarCheck,
  faAsterisk,
  faHeart,
  faMapMarkedAlt,
  faPlaneDeparture,
  faReply,
  faSuitcase,
} from "@fortawesome/free-solid-svg-icons";
import Invitado from "./elementos/invitado";

export default function clasico({ datos, setYtLoad }) {
  const fecha_evento = formatearFecha(datos.novios.fecha_evento);
  const fecha_limite = formatearFecha(datos.novios.fecha_limite);

  const nombre_padres_novio = (datos.novios?.descripcion_novio || "")
    .split(",")
    .map((item) => {
      return `<p class="sub-heading m-0">${item.trim()}</p>`;
    })
    .join("");

  const nombre_padres_novia = (datos.novios?.descripcion_novia || "")
    .split(",")
    .map((item) => {
      return `<p class="sub-heading m-0">${item.trim()}</p>`;
    })
    .join("");

  return (
    <>
      <CustomThemes theme={themes.clasico} />
      <OpeningLetter />
      <header className="header">
        <h1 className="heading">
          {datos.novios.nombre_novio} & {datos.novios.nombre_novia}
          <span className="heading-subtext">¡se van a Casar!</span>
        </h1>
      </header>
      <a data-scroll className="fixed-button" href="#rsvp" id="rsvpButton">
        Confirmar
      </a>
      <section className="section container">
        <h1 className="sub-heading fs-6em mt-1">Nuestra Boda</h1>
        <div className="row">
          <div className="col-md-2"></div>
          <div className="col-md-8">
            <p className="sub-heading mt-5">
              Con la presencia y bendición de Dios, y el amor de nuestros
              padres:
            </p>
          </div>
          <div className="col-md-2"></div>
        </div>
        <div className="row">
          <div className="col-md-2"></div>
          <div
            className="col-md-4"
            dangerouslySetInnerHTML={{ __html: nombre_padres_novio }}
          ></div>
          <div
            className="col-md-4"
            dangerouslySetInnerHTML={{ __html: nombre_padres_novia }}
          ></div>
          <div className="col-md-2"></div>
        </div>
        <Invitado
          invitado={datos.invitados}
          texto_personalizado={datos.novios.texto_personalizado}
        ></Invitado>
        <div className="row">
          <div className="col-xl-2"></div>
          <div className="col-xl-8 sub-heading mt-2 title-encab d-flex flex-column justify-content-center">
            <p className="lh-sm text-center fs-1">
              {datos.novios.versiculo_text}
            </p>
            <p className="lh-sm text-end fs-1 mt-1">
              {datos.novios.versiculo_ref}
            </p>
          </div>
          <div className="col-xl-2"></div>
        </div>
      </section>
      <section className="section container">
        <h2 className="sub-heading m-0 mb-4 fs-5em">
          La Ceremonia será el dia
        </h2>
        <h3 className="details-heading mb-4">{fecha_evento.texto}</h3>
        <div className="row mt-5">
          <div className="col-md-2"></div>
          <div className="col-md-4">
            <a
              className="text-decoration-none text-black text-center img-md"
              target="_blank"
              href={datos.novios.url_fecha_evento}
              title="calendar"
            >
              <FontAwesomeIcon
                icon={faCalendarCheck}
                size="4x"
                className="color-secondary"
              />
              <br />
              <span>Guarda la fecha en tu calendario</span>
            </a>
          </div>
          <div className="col-md-4">
            <a
              className="text-decoration-none text-black text-center img-md"
              rel="noopener noreferrer"
              target="_blank"
              href={datos.novios.url_dir_evento}
              title="ubicacion"
            >
              <FontAwesomeIcon
                icon={faMapMarkedAlt}
                size="4x"
                className="color-secondary"
              />
              <p>{datos.novios.dir_evento}</p>
            </a>
          </div>
          <div className="col-md-2"></div>
        </div>
        <div className="details">
          <FontAwesomeIcon
            icon={faSuitcase}
            size="4x"
            className="color-secondary"
          />
          <h3 className="details-heading">Alojamiento</h3>
          <p>Texto Personalizado</p>
        </div>
        <div className="details">
          <FontAwesomeIcon
            icon={faPlaneDeparture}
            size="4x"
            className="color-secondary"
          />
          <h3 className="details-heading">Vuelos</h3>
          <p>Texto Personalizado</p>
        </div>
        <div className="details">
          <FontAwesomeIcon
            icon={faAsterisk}
            size="4x"
            className="color-secondary"
          />
          <h3 className="details-heading">Otras Notas</h3>
          <p>Texto Personalizado</p>
        </div>
        <div className="details">
          <FontAwesomeIcon
            icon={faReply}
            size="4x"
            className="color-secondary"
          />
          <h3 className="details-heading" id="rsvp">
            Confirmar
          </h3>
          <div className="row">
            <div className="col-12">
              <h4>
                Estamos muy emocionados de celebrar contigo nuestro matrimonio
              </h4>
              <button className="btn btn-danger p-4 m-4" type="button">
                No pordré asistir
              </button>
              <button className="btn btn-success p-4 m-4" type="button">
                Confirmo mi asistencia
              </button>
            </div>
          </div>
        </div>
      </section>
      <section id="audio">
        <Music
          link={datos.novios.url_musica}
          designe={datos.usuario.designe}
          setYtLoad={setYtLoad}
        ></Music>
      </section>

      <footer className="footer mb-6">
        <div className="copy-right_text">
          <div className="footer_border"></div>
          <div className="row">
            <div className="col-xl-12">
              <p className="copy_right text-center m-5">
                Todos los derechos reservados &copy;MyBoda
                <script>document.write(new Date().getFullYear());</script>
                <FontAwesomeIcon icon={faHeart} /> Desarrollado por
                <a href="https://myboda.cl" target="_blank">
                  Jiempy SpA
                </a>
              </p>
            </div>
          </div>
        </div>
      </footer>

      {/*   <header className="header">
        <h1 className="heading">
          {datos.novios.nombre_novio} & {datos.novios.nombre_novia}
          <span className="heading-subtext">¡se van a Casar!</span>
        </h1>
      </header>
      <a data-scroll className="fixed-button" href="#rsvp" id="rsvpButton">
        Confirmar
      </a>
      <section className="section container">
        <h2 className="sub-heading">{datos.usuario.invitado}</h2>
        <h3>{datos.usuario.msg_invitado}</h3>
      </section>
      <section className="section container">
        <h2 className="sub-heading">Te esperamos el:</h2>
        <div className="details"><FontAwesomeIcon icon={faCalendarCheck} />
          <p>
            {fecha_evento.diaNumero +
              " de " +
              fecha_evento.mesNombre +
              " del " +
              fecha_evento.año}
          </p>
          <a
            title="Guardar en mi calendario"
            rel="noopener"
            href={`${datos.novios.url_fecha_evento}`}
            target="_blank"
            className="btn btn-outline-danger"
          >
            Guardar en mi calendario
          </a>
        </div>
        <div className="details">
        <FontAwesomeIcon icon={faMarketAlt} />
          <h3 className="details-heading">
            Nuestra ceremonia será en {datos.novios.dir_evento}
          </h3>
          <iframe
            title="direccion"
            src={`${datos.novios.embed_dir_evento}`}
            style={{ border: "0", width: "100%", height: "70vh" }}
            allowFullScreen
            loading="lazy"
            referrerPolicy="no-referrer-when-downgrade"
          ></iframe>
        </div>
      </section>
      <Cronograma eventos={datos.cronograma} />
      <section>
        <div className="details">
        <FontAwesomeIcon icon={faPlaneDeparture} />
          <h3 className="details-heading">Obsequio</h3>
          <p>
            Tu presencia es el mejor regalo que nos puedes dar en este día tan
            especial, pero si deseas brindarnos un obsequio agradeceríamos que
            fuera por este medio:
          </p>
        </div>
        <div className="details">
        <FontAwesomeIcon icon={faReply} />
          <h3 className="details-heading" id="rsvp">
            Estamos muy emocionados de celebrar contigo nuestro matrimonio
          </h3>
          <div className="">
            <div className="">
              <h5>
                Puedes confirmar tu asistencia hasta el:
                {" " +
                  fecha_limite.diaNumero +
                  " de " +
                  fecha_limite.mesNombre +
                  " del " +
                  fecha_limite.año}
              </h5>
              <button className="btn btn-danger p-4 m-4" type="button">
                No pordré asistir
              </button>
              <button className="btn btn-success p-4 m-4" type="button">
                Confirmo mi asistencia
              </button>
            </div>
          </div>
        </div>
      </section>
      <section id="audio">
        <Music
          link={datos.novios.url_musica}
          designe={datos.usuario.designe}
          setYtLoad={setYtLoad}
        ></Music>
      </section>

      <footer className="footer mt-5">
        <div className="row">
          <div className="copyright-text">
            <p className="copy_right text-center font-family-lora m-5">
              Todos los derechos reservados &copy;MyBoda
              <script>document.write(new Date().getFullYear());</script>{" "}
              <FontAwesomeIcon icon={faHeart}/> Desarrollado por{" "}
             <a href="https://myboda.cl" target="_blank">
                Jiempy SpA
              </a>
            </p>
          </div>
        </div>
      </footer>*/}
    </>
  );
}
