"use client";

import React, { useEffect, useState } from "react";
import Loader from "./Loader";

const PreLoader = ({ children }) => {
  const [isLoading, setIsLoading] = useState(true);

  useEffect(() => {
    const handleLoad = () => {
      setIsLoading(false);
    };

    if (document.readyState === "complete") {
      handleLoad();
    } else {
      window.addEventListener("load", handleLoad);
    }

    return () => {
      window.removeEventListener("load", handleLoad);
    };
  }, []);

  useEffect(() => {
    if (!isLoading) {
      if (typeof window !== "undefined") {
        const hash = window.location.hash;
        if (hash) {
          const element = document.querySelector(hash);
          if (element) {
            element.scrollIntoView({ behavior: "smooth" });
          }
        }
      }
    }
  }, [isLoading]);

  if (isLoading) {
    return <Loader></Loader>;
  }

  return children;
};

export default PreLoader;
