"use client";

import Link from "next/link";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faUser,
  faSignInAlt,
  faSignOutAlt,
} from "@fortawesome/free-solid-svg-icons";
import { useEffect, useState } from "react";
import Loader from "@/components/Loader";
import { useRouter } from "next/navigation";
import { api } from "@/libs/apiClient";
import { getSession } from "@/libs/session";

export default function Navbar() {
  const [menu, setMenu] = useState(undefined);
  const [isLoading, setIsLoading] = useState(false);
  const router = useRouter();

  const openLoader = (e) => {
    const pathname = window.location.pathname;
    if (pathname.replace("/", "") !== e) {
      setIsLoading(true);
    }
  };

  const exit_session = async (e) => {
    setIsLoading(true);

    try {
      await api.delete("/session/delete");

      router.push("/login");
    } catch (error) {
      console.error(error.message);
      setIsLoading(false);
    } finally {
    }
  };

  useEffect(() => {
    require("bootstrap/dist/js/bootstrap.bundle.min.js");
  }, [menu]);

  useEffect(() => {
    const fetchSession = async () => {
      try {
        const session = await getSession();
        if (session && session.menuData) {
          setMenu(session.menuData);
          setIsLoading(false);
        } else {
         // router.push("/login");
        }
      } catch (error) {
        console.error("Error al obtener la sesión", error);
       // router.push("/login");
      }
    };

    fetchSession();
  }, []);

  useEffect(() => {
    const pathname = window.location.pathname;

    const esPaginaPrincipal = pathname === "/" || pathname === "";

    if (esPaginaPrincipal) {
      setMenu(undefined);
    }
  }, [menu]);

  return (
    <nav
      className="navbar navbar-expand-lg navbar-light fixed-top py-3"
      data-navbar-on-scroll="data-navbar-on-scroll"
    >
      <div className="container mt-2">
        <button
          className="navbar-toggler collapsed order-lg-1 order-2"
          type="button"
          data-bs-toggle="collapse"
          data-bs-target="#navbarSupportedContent"
          aria-controls="navbarSupportedContent"
          aria-expanded="false"
          aria-label="Toggle navigation"
        >
          <span className="navbar-toggler-icon"></span>
        </button>
        <div
          className="collapse navbar-collapse border-top border-lg-0 mt-4 mt-lg-0 order-lg-1 order-2"
          id="navbarSupportedContent"
        >
          {isLoading ? (
            <Loader></Loader>
          ) : !menu ? (
            <ul className="navbar-nav me-auto mb-2 mb-lg-0">
              <li className="nav-item px-3">
                <Link className="nav-link fw-bold" href="#header">
                  INICIO
                </Link>
              </li>
              <li className="nav-item px-3">
                <Link
                  className="nav-link fw-bold"
                  aria-current="page"
                  href="#services"
                >
                  SERVICIOS
                </Link>
              </li>
              <li className="nav-item px-3">
                <Link className="nav-link fw-bold" href="#testimonials">
                  TESTIMONIOS
                </Link>
              </li>
              <li className="nav-item px-3 d-none">
                <Link className="nav-link fw-bold" href="#precios">
                  PRECIOS
                </Link>
              </li>
              <li className="nav-item px-3">
                <Link className="nav-link fw-bold" href="#modelos">
                  DISEÑOS
                </Link>
              </li>
              <li className="nav-item px-3">
                <Link className="nav-link fw-bold" href="#contact">
                  CONTACTANOS
                </Link>
              </li>
              <li className="nav-item px-3">
                <Link
                  className="nav-link fw-bold"
                  href="/login"
                  onClick={() => openLoader("/login")}
                >
                  <FontAwesomeIcon icon={faSignInAlt} />
                  <FontAwesomeIcon icon={faUser} />
                </Link>
              </li>
            </ul>
          ) : (
            <ul className="navbar-nav me-auto mb-2 mb-lg-0">
              <li className="nav-item px-3">
                <Link
                  className="nav-link fw-bold"
                  href="/intranet"
                  onClick={() => openLoader("/intranet")}
                >
                  INICIO
                </Link>
              </li>
              {menu.map((item, index) =>
                item.action !== "" ? (
                  <li key={index} className="nav-item px-3">
                    <Link
                      className="nav-link fw-bold"
                      href={item.action}
                      onClick={() => openLoader(item.action)}
                    >
                      {item.nombre}
                    </Link>
                  </li>
                ) : (
                  <li key={index} className="nav-item dropdown px-3">
                    <a
                      href="#"
                      className="nav-link dropdown-toggle fw-bold"
                      role="button"
                      data-bs-toggle="dropdown"
                      aria-expanded="false"
                    >
                      {item.nombre}
                    </a>
                    <ul className="dropdown-menu">
                      {item.submenus.map((subItem, subIndex) => (
                        <li key={subIndex}>
                          <Link
                            className="dropdown-item"
                            href={subItem.action}
                            onClick={() => openLoader(subItem.action)}
                          >
                            {subItem.nombre}
                          </Link>
                        </li>
                      ))}
                    </ul>
                  </li>
                )
              )}

              <li className="nav-item px-3">
                <button
                  className="nav-link fw-bold"
                  type="button"
                  onClick={exit_session}
                >
                  <FontAwesomeIcon icon={faUser} />
                  <FontAwesomeIcon icon={faSignOutAlt} />
                </button>
              </li>
            </ul>
          )}
        </div>
      </div>
    </nav>
  );
}
