"use client";
import React, { useEffect } from "react";
import ReactDOM from "react-dom";
import "@/styles/modal_empty.css";

const ModalEmpty = ({
  onClose,
  children,
  title,
  size = "medium",
  buttons = null,
  showCloseButton = true,
  customClass = "",
  closeOnOutsideClick = true,
}) => {
  useEffect(() => {
    const handleEsc = (e) => {
      if (e.key === "Escape") onClose();
    };
    document.addEventListener("keydown", handleEsc);
    return () => document.removeEventListener("keydown", handleEsc);
  }, [onClose]);

  const sizeClass =
    {
      small: "modal-small",
      medium: "modal-medium",
      large: "modal-large",
    }[size] || "";

  const modalContent = (
    <div
      className="react-modal-overlay"
      onClick={() => {
        if (closeOnOutsideClick) onClose();
      }}
    >
      <div
        className={`react-modal-wrapper ${sizeClass} ${customClass}`}
        onClick={(e) => e.stopPropagation()}
      >
        <div className="react-modal">
          <div className="react-modal-header">
            {title && <h2 className="react-modal-title">{title}</h2>}
            {showCloseButton && (
              <button className="react-modal-close" onClick={onClose}>
                &times;
              </button>
            )}
          </div>

          <div className="react-modal-body">{children}</div>

          {buttons && <div className="react-modal-footer">{buttons}</div>}
        </div>
      </div>
    </div>
  );

  if (typeof window === "undefined") return null;

  return ReactDOM.createPortal(
    modalContent,
    document.getElementById("modal-root")
  );
};

export default ModalEmpty;
