"use client";

import React, { useEffect, useRef } from "react";
import { createPortal } from "react-dom";
import { Modal as BootstrapModal } from "bootstrap";

const ModalBootstrap = ({
  id,
  show,
  onClose,
  title,
  children,
  headerContent,
  footerContent,
  showHeader = true,
  showFooter = true,
}) => {
  const modalRef = useRef();
  const bsModal = useRef(null);

  useEffect(() => {
    bsModal.current = new BootstrapModal(modalRef.current, {
      backdrop: "static",
      keyboard: false,
    });

    return () => {
      bsModal.current?.dispose();
    };
  }, []);

  useEffect(() => {
    if (!bsModal.current) return;

    if (show) {
      bsModal.current.show();
    } else {
      bsModal.current.hide();
    }
  }, [show]);

  useEffect(() => {
    const el = modalRef.current;
    const handleHidden = () => {
      if (onClose) onClose(); 
    };

    el.addEventListener("hidden.bs.modal", handleHidden);

    return () => {
      el.removeEventListener("hidden.bs.modal", handleHidden);
    };
  }, [onClose]);

  return createPortal(
    <div
      className="modal fade"
      id={id}
      tabIndex="-1"
      aria-labelledby={`${id}Label`}
      aria-hidden="true"
      ref={modalRef}
    >
      <div className="modal-dialog">
        <div className="modal-content font-family-lora">
          {showHeader && (
            <div className="modal-header">
              {headerContent || <h5 className="modal-title">{title}</h5>}
              <button
                type="button"
                className="btn-close"
                data-bs-dismiss="modal"
                aria-label="Cerrar"
              ></button>
            </div>
          )}

          <div className="modal-body">{children}</div>

          {showFooter && (
            <div className="modal-footer d-flex justify-content-center">
              {footerContent || (
                <button
                  type="button"
                  className="btn btn-success fs-4 btn-sm"
                  data-bs-dismiss="modal"
                >
                  Cerrar
                </button>
              )}
            </div>
          )}
        </div>
      </div>
    </div>,
    document.body
  );
};

export default ModalBootstrap;
