"use client";
import React, { useEffect } from "react";
import ReactDOM from "react-dom";
import "@/styles/modal.css";

const Modal = ({ onClose, children, title, type = "info" }) => {
  useEffect(() => {
    const handleEsc = (e) => {
      if (e.key === "Escape") onClose();
    };
    document.addEventListener("keydown", handleEsc);
    return () => document.removeEventListener("keydown", handleEsc);
  }, [onClose]);

  const modalClass = `react-modal react-modal-${type}`;

  const modalContent = (
    <div className="react-modal-overlay" onClick={onClose}>
      <div className="react-modal-wrapper" onClick={(e) => e.stopPropagation()}>
        <div className={modalClass}>
          <div className="react-modal-header">
            {title && <h2 className="react-modal-title">{title}</h2>}
            <button className="react-modal-close" onClick={onClose}>
              &times;
            </button>
          </div>
          <div className="react-modal-body">{children}</div>
          <div className="react-modal-footer">
            <button type="button" onClick={onClose} className={`btn btn-${type}`}>
              cerrar
            </button>
          </div>
        </div>
      </div>
    </div>
  );

  if (typeof window === "undefined") return null;

  return ReactDOM.createPortal(
    modalContent,
    document.getElementById("modal-root")
  );
};

export default Modal;
