import Link from "next/link";
import Layout from "@/app/layout/layout-Empty";
import "@/styles/notfound.css";

export default function DesigneNotFound() {
    return (
        <Layout>
            <section className="mt-5 py-5">
                <section className="error-container">
                    <span className="four"><span className="screen-reader-text">4</span></span>
                    <span className="zero"><span className="screen-reader-text">0</span></span>
                    <span className="four"><span className="screen-reader-text">4</span></span>
                </section>
                <p className="zoom-area"><b>El numero telefono no tiene un invitacion asociada.</b></p>
                <div className="link-container">
                    <Link href="/" className="btn btn-danger mx-3">Volver al inicio</Link>
                </div>
            </section>
        </Layout>
    );
}