"use client";

import { useEffect } from "react";
import Layout from "@/app/layout/layout-Empty";

export default function Privacy() {
  useEffect(() => {
    require("bootstrap/dist/js/bootstrap.bundle.min.js");
  }, []);

  return (
    <Layout>
      {/*header Section */}
      <section id="header" className="header bg-light">
        <div className="overlay"></div>
      </section>
      {/*Privacity Section */}
      <section className="" id="privacy">
        <div className="container">
          <div className="row h-100">
            <div className="col-lg-7 mt-7">
              <h4 className="lh-lg fw-bold text-uppercase mt-4">
                Política de Privacidad de MyBoda
              </h4>
            </div>
            <div className="row align-items-justify mt-4">
              <p className="fw-bold">
                Fecha de entrada en vigencia: 01-08-2024{" "}
              </p>
              <p>
                En MyBoda, nos tomamos en serio la privacidad de nuestros
                usuarios. Esta Política de Privacidad describe cómo recopilamos,
                utilizamos y protegemos la información personal que nos
                proporcionas. Al utilizar nuestros servicios, aceptas las
                prácticas descritas en esta política.
              </p>
              <p className="fw-bold">1. Información Recopilada</p>
              <p>
                Recopilamos información personal que tú proporcionas
                directamente, como nombre, dirección de correo electrónico y
                datos de contacto. También podemos recopilar información sobre
                tu uso de nuestros servicios de manera automática, a través de
                cookies y tecnologías similares.
              </p>
              <p className="fw-bold">2. Uso de la Información</p>
              <p>
                Utilizamos la información recopilada para proporcionar y mejorar
                nuestros servicios, personalizar la experiencia del usuario,
                enviar comunicaciones relacionadas con el servicio y gestionar
                tu cuenta. No compartiremos tu información personal con terceros
                sin tu consentimiento, excepto según lo exija la ley.
              </p>
              <p className="fw-bold">3. Protección de la Información</p>
              <p>
                Implementamos medidas de seguridad para proteger tu información
                personal contra acceso no autorizado o divulgación. Sin embargo,
                ten en cuenta que ninguna medida de seguridad en línea es
                completamente impenetrable.
              </p>
              <p className="fw-bold">4. Derechos de Privacidad del Usuario</p>
              <p>
                Tienes el derecho de acceder, corregir o eliminar tu información
                personal. Para ejercer estos derechos o para cualquier pregunta
                relacionada con esta política, por favor, contáctanos a través
                de{" "}
                <a
                  href="mailto:contacto@myboda.cl"
                  className="fw-bold text-dark"
                >
                  contacto@myboda.cl
                </a>
                .
              </p>
              <p className="fw-bold">5. Cambios en la Política de Privacidad</p>
              <p>
                Nos reservamos el derecho de modificar esta Política de
                Privacidad en cualquier momento. Cualquier cambio será efectivo
                inmediatamente después de la publicación de la versión
                actualizada en nuestro sitio web. Te alentamos a revisar
                periódicamente esta política para estar informado sobre cómo
                estamos protegiendo tu información.
              </p>
              <p>
                Al utilizar nuestros servicios, aceptas los términos de esta
                Política de Privacidad. Si no estás de acuerdo con estos
                términos, por favor, no utilices nuestros servicios.
              </p>
              <p>Gracias por confiar en nosotros.</p>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
