"use client";

import { useEffect, useState } from "react";
import Layout from "@/app/layout/layout-Empty";
import Link from "next/link";

export default function PresupuestoPage() {
  const [urlWhatsApp, setUrlWhatsApp] = useState("");

  useEffect(() => {
    const numeroWhatsApp = "56982465650";
    const params = new URLSearchParams(window.location.search);

    let mensaje = "Hola, estoy interesado en las invitaciones de MyBoda, me pueden enviar mas información?.";

    if (params.has("inicial")) {
      mensaje = "Hola, Quiero más información sobre el Paquete Inicial.";
    } else if (params.has("basico")) {
      mensaje = "Hola, Quiero más información sobre el Paquete Básico.";
    } else if (params.has("automatizado")) {
      mensaje =
        "Hola, Quiero más información sobre el Paquete con automatización en Whatsapp.";
    } else if (params.has("avanzado")) {
      mensaje = "Hola, Quiero más información sobre el Paquete Avanzado.";
    } else if (params.has("informacion")) {
      mensaje = "Hola, estoy interesado en las invitaciones de MyBoda, me pueden enviar mas información?.";
    }

    const url = `https://wa.me/${numeroWhatsApp}?text=${encodeURIComponent(
      mensaje
    )}`;

    setUrlWhatsApp(url);
  }, []);

  useEffect(() => {
    if (urlWhatsApp) {
      window.location.href = urlWhatsApp;
    }
  }, [urlWhatsApp]);

  return (
    <Layout>
      <main className="content-main">
        <section className="header bg-light">
          <div className="overlay"></div>
          <div id="login" className="auto-container mt-5 mb-5">
            <div className="row justify-content-center">
              <div className="col-md-12">
                <div className="card card shadow-lg p-4 p-sm-5">
                  <div className="card-title">
                    <h5 className="card-title text-center fs-5 ">
                      Redirigiendo...
                    </h5>
                  </div>
                  <div className="card-body">
                    <span className="text-center">
                      <strong>Si no fuiste redirigido automáticamente, </strong>
                      {urlWhatsApp && (
                        <Link
                          href={urlWhatsApp}
                          className="btn btn-success btn-login text-uppercase fw-bold float-right"
                          target="_blank"
                          rel="noopener noreferrer"
                        >
                          haz clic aquí
                        </Link>
                      )}
                    </span>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </section>
      </main>
    </Layout>
  );
}
