"use client";

import { useEffect } from "react";
import Layout from "@/app/layout/layout-page";
import Image from "next/image";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";

import {
  faBell,
  faChartColumn,
  faChartLine,
  faCheckCircle,
  faChevronLeft,
  faChevronRight,
  faClock,
  faEnvelopeOpen,
  faLeaf,
  faMobile,
  faMusic,
  faPaintbrush,
  faPaintBrush,
  faPalette,
  faImage,
  faScrewdriverWrench,
  faShieldHeart,
  faUser,
} from "@fortawesome/free-solid-svg-icons";
import { faWhatsapp } from "@fortawesome/free-brands-svg-icons";
import Link from "next/link";

export default function Index() {
  useEffect(() => {
    require("bootstrap/dist/js/bootstrap.bundle.min.js");
  }, []);

  return (
    <Layout>
      {/*header Section */}
      <section id="header" className="header bg-light">
        <div className="overlay"></div>
      </section>

      {/*Services Section */}
      <section id="services" className="py-6">
        <div className="container">
          <div className="row text-center">
            <div className="col-lg-12">
              <h2 className="section-title title-color-primary">
                ¿Por qué elegir nuestras Invitaciones de Matrimonio Digitales?
              </h2>
              <p className="section-subtitle mt-4">
                Hacemos que el proceso de invitar a tus seres queridos sea
                fácil, elegante y memorable. Descubre los beneficios únicos de
                nuestras invitaciones digitales personalizadas.
              </p>
            </div>
          </div>
          <div className="row mt-5">
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faMobile}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Comodidad y Accesibilidad
                  </h4>
                  <p className="card-text">
                    Envío instantáneo de invitaciones a través de WhatsApp o
                    correo electrónico, permitiendo a tus invitados acceder a la
                    invitación en cualquier momento y lugar, sin las
                    complicaciones de papel y mensajería física.
                  </p>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faLeaf}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Sostenibilidad y Eco-amigable
                  </h4>
                  <p className="card-text">
                    Opta por una solución verde, reduciendo el impacto ambiental
                    al eliminar el uso de papel y tinta. Nuestras invitaciones
                    digitales son elegantes y responsables con el medio
                    ambiente.
                  </p>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faPaintBrush}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Personalización Total
                  </h4>
                  <p className="card-text">
                    Creamos invitaciones que se adaptan a tu estilo único,
                    permitiéndote personalizar cada detalle, desde los colores
                    hasta las imágenes, para que reflejen fielmente la esencia
                    de tu boda.
                  </p>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faClock}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Recordatorios Automáticos
                  </h4>
                  <p className="card-text">
                    Programamos recordatorios automáticos que se enviarán a tus
                    invitados en fechas clave, asegurando que nadie se olvide de
                    tu gran día.
                  </p>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faChartLine}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Panel de Administración Intuitivo
                  </h4>
                  <p className="card-text">
                    Gestiona tu lista de invitados de manera eficiente con
                    nuestro panel de administración. Haz seguimiento de las
                    confirmaciones de asistencia en tiempo real, sin estrés ni
                    complicaciones.
                  </p>
                </div>
              </div>
            </div>
            <div className="col-lg-4 col-md-6 mb-4">
              <div className="card h-100 shadow border-0">
                <div className="card-body text-center">
                  <div className="icon-box mb-3">
                    <FontAwesomeIcon
                      icon={faEnvelopeOpen}
                      className="title-color-primary"
                      size="3x"
                    />
                  </div>
                  <h4 className="card-title title-color-primary">
                    Respuesta Instantánea
                  </h4>
                  <p className="card-text">
                    Tus invitados pueden confirmar su asistencia con un solo
                    clic. Sin papeleo ni complicaciones, te proporcionamos la
                    tecnología para que todo sea rápido y simple.
                  </p>
                </div>
              </div>
            </div>
          </div>
          <div className="row text-center mt-5">
            <div className="col-lg-12">
              <p className="call-to-action-text">
                ¿Listo para sorprender a tus invitados con invitaciones
                elegantes, prácticas y sostenibles?{" "}
              </p>
              <strong className=" title-color-primary mt-5 text-center">
                ¡Contáctanos ahora!
              </strong>
            </div>
          </div>
        </div>
      </section>

      {/* Testimonials Section */}

      <section id="testimonials" className="bg-light py-6">
        <div className="container">
          <div className="text-center mb-5">
            <h2 className="section-title title-color-primary">Testimonios</h2>
            <p className="section-subtitle">
              Lo que dicen nuestros novios felices.
            </p>
          </div>
          <div className="row">
            <div className="col-md-4">
              <blockquote className="blockquote text-center">
                <p>
                  {
                    '"Las invitaciones de MyBoda fueron hermosas y fáciles de enviar. ¡Totalmente recomendadas!"'
                  }
                </p>
                <hr></hr>
                <footer className="blockquote-footer fw-bolder mt-2">
                  {"Ana y Miguel"}
                </footer>
              </blockquote>
            </div>
            <div className="col-md-4">
              <blockquote className="blockquote text-center">
                <p>
                  {
                    '"Pudimos personalizar nuestras invitaciones como queríamos, ¡fue perfecto!"'
                  }
                </p>
                <hr></hr>
                <footer className="blockquote-footer fw-bolder mt-2">
                  {"Laura y Pedro"}
                </footer>
              </blockquote>
            </div>
            <div className="col-md-4">
              <blockquote className="blockquote text-center">
                <p>
                  {
                    '"La gestión de invitados fue sencilla y efectiva. No tuvimos que preocuparnos por nada."'
                  }
                </p>
                <hr></hr>
                <footer className="blockquote-footer fw-bolder mt-2">
                  {"Carlos y María"}
                </footer>
              </blockquote>
            </div>
          </div>
        </div>
      </section>

      {/* Valores Section */}

      <section id="precios" className="py-6 d-none">
        <div className="container">
          <div className="text-center mb-5">
            <h2 className="section-title title-color-primary">
              Elige el paquete perfecto para tu evento
            </h2>
            <p className="text-center">
              Conoce nuestros paquetes y descubre cuál se adapta mejor a tus
              necesidades. ¡Todos incluyen diseños profesionales y una
              experiencia inolvidable!
            </p>
          </div>
          <div className="row mt-5">
            <div className="container my-5">
              <div className="row gy-4">
                <div className="col-12 col-md-6 col-lg-3">
                  <div className="card shadow-sm h-100">
                    <div className="card-head card-h4 py-4">
                      <h5 className="card-title text-center">
                        <FontAwesomeIcon
                          icon={faShieldHeart}
                          className="icon-danger"
                          size="1x"
                        />{" "}
                        Paquete Inicial
                      </h5>
                      <hr className="bg-danger border-3 border-top border-danger" />
                      <p className="card-text text-center fw-bold text-primary fs-3 text-success">
                        $24,990
                      </p>
                    </div>
                    <div className="card-body">
                      <ul className="list-unstyled">
                        <li>
                          <FontAwesomeIcon
                            icon={faPalette}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          6 plantillas de diseño profesional.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faPaintbrush}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de colores.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faMusic}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de música.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faScrewdriverWrench}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Asistencia inicial.
                        </li>
                      </ul>
                    </div>
                    <div className="card-footer text-center">
                      <Link
                        href="/presupuesto?inicial"
                        target="_blank"
                        className="btn btn-success btn-lg my-2"
                      >
                        Solicitar Paquete
                      </Link>
                    </div>
                  </div>
                </div>
                <div className="col-12 col-md-6 col-lg-3">
                  <div className="card shadow-sm h-100">
                    <div className="card-head card-h4 py-4">
                      <h5 className="card-title text-center">
                        <FontAwesomeIcon
                          icon={faShieldHeart}
                          className="icon-danger"
                          size="1x"
                        />{" "}
                        Paquete Básico
                      </h5>
                      <hr className="bg-danger border-3 border-top border-danger" />
                      <p className="card-text text-center fw-bold text-primary fs-3 text-success">
                        $59,990
                      </p>
                    </div>
                    <div className="card-body">
                      <ul className="list-unstyled">
                        <li>
                          <FontAwesomeIcon
                            icon={faPalette}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          6 plantillas de diseño profesional.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faPaintbrush}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de colores.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faMusic}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de música.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personaliza nombres de invitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Invitados ilimitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faImage}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Galería de fotos.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faCheckCircle}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Sección interactiva para aceptar o rechazar la
                          invitación.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faChartColumn}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Panel para ver quiénes aceptaron o rechazaron.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faScrewdriverWrench}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Asistencia básica.
                        </li>
                      </ul>
                    </div>
                    <div className="card-footer text-center">
                      <Link
                        href="/presupuesto?basico"
                        target="_blank"
                        className="btn btn-success btn-lg my-2"
                      >
                        Solicitar Paquete
                      </Link>
                    </div>
                  </div>
                </div>
                <div className="col-12 col-md-6 col-lg-3">
                  <div className="card shadow-sm h-100">
                    <div className="card-head card-h4  py-4 ">
                      <h5 className="card-title text-center">
                        <FontAwesomeIcon
                          icon={faShieldHeart}
                          className="icon-danger"
                          size="1x"
                        />{" "}
                        Paquete con Automatización WhatsApp
                      </h5>
                      <hr className="bg-danger border-3 border-top border-danger" />
                      <p className="card-text text-center fw-bold text-primary fs-3 text-success">
                        $89,990
                      </p>
                    </div>
                    <div className="card-body">
                      <ul className="list-unstyled">
                        <li>
                          <FontAwesomeIcon
                            icon={faPalette}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          6 plantillas de diseño profesional.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faPaintbrush}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de colores.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faMusic}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de música.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personaliza nombres de invitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Invitados ilimitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faImage}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Galería de fotos.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faCheckCircle}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Sección interactiva para aceptar o rechazar la
                          invitación.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faChartColumn}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Panel para ver quiénes aceptaron o rechazaron.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faWhatsapp}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Envío automático de invitaciones por WhatsApp.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faBell}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Recordatorios automáticos para tus invitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faScrewdriverWrench}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Asistecia personalizada
                        </li>
                      </ul>
                    </div>
                    <div className="card-footer text-center">
                      <Link
                        href="/presupuesto?automatizacion"
                        target="_blank"
                        className="btn btn-success btn-lg my-2"
                      >
                        Solicitar Paquete
                      </Link>
                    </div>
                  </div>
                </div>
                <div className="col-12 col-md-6 col-lg-3">
                  <div className="card shadow-sm h-100">
                    <div className="card-head card-h4 text-center py-4">
                      <h5 className="card-title">
                        <FontAwesomeIcon
                          icon={faShieldHeart}
                          className="icon-danger"
                          size="1x"
                        />{" "}
                        Paquete Avanzado
                      </h5>
                      <hr className="bg-danger border-3 border-top border-danger" />
                      <p className="card-text text-center fw-bold text-primary fs-3 text-success">
                        $129,990
                      </p>
                    </div>
                    <div className="card-body">
                      <ul className="list-unstyled">
                        <li>
                          <FontAwesomeIcon
                            icon={faPalette}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Diseño personalizado, único para tu evento.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faPaintbrush}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de colores.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faMusic}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personalizacion de música.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Personaliza nombres de invitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faUser}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Invitados ilimitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faImage}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Galería de fotos.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faCheckCircle}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Sección interactiva para aceptar o rechazar la
                          invitación.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faChartColumn}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Panel para ver quiénes aceptaron o rechazaron.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faWhatsapp}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Envío automático de invitaciones por WhatsApp.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faBell}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Recordatorios automáticos para tus invitados.
                        </li>
                        <li>
                          <FontAwesomeIcon
                            icon={faScrewdriverWrench}
                            className="icon-success"
                            size="1x"
                          />{" "}
                          Asistencia Avanzada
                        </li>
                      </ul>
                    </div>
                    <div className="card-footer text-center">
                      <Link
                        href="/presupuesto?avanzado"
                        target="_blank"
                        className="btn btn-success btn-lg my-2"
                      >
                        Solicitar Paquete
                      </Link>
                    </div>
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/*Sección de Galería*/}

      <section id="modelos" className="py-5 mt-6">
        <div className="container">
          <div className="row text-center mb-5">
            <div className="col-lg-12">
              <h1 className="section-title title-color-primary">
                Galería de Diseños
              </h1>
              <p className="section-subtitle">
                Explora algunos de nuestros diseños interactivos personalizados
                que ofrecemos para tus invitaciones de boda digitales.
              </p>
            </div>
          </div>
          <div className="row g-4">
            {/* Diseño 1 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <a href="https://invitaciones.myboda.cl/designs/clasico/index.html" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/clasico.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Clásica"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Clásica
                  </h5>
                </div>
              </div>
            </div>
            {/* Diseño 2 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <a href="https://invitaciones.myboda.cl/designs/elegante/index.html" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/elegante.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Elegante"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Elegante
                  </h5>
                </div>
              </div>
            </div>
            {/* Diseño 3 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <a href="https://invitaciones.myboda.cl/designs/minimalista/index.html" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/minimalista.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Minimalista"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Minimalista
                  </h5>
                </div>
              </div>
            </div>
            {/* Diseño 4 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <a href="https://invitaciones.myboda.cl/designs/narrativa/index.html" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/narrativa.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Narrativa"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Narrativa
                  </h5>
                </div>
              </div>
            </div>
            {/* Diseño 5 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <a href="https://invitaciones.myboda.cl/designs/romantico/index.html" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/romantico.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Romantico"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </a>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Romantico
                  </h5>
                </div>
              </div>
            </div>
            {/* Diseño 6 */}
            <div className="col-md-6 col-lg-4 mt-5">
              <div className="card border-0 shadow-sm h-100">
                <div className="phone-frame mt-5 mb-3">
                  <Link href="/vintage/123" target="_blank">
                    <div className="phone-frame-img position-relative">
                      <Image
                        src="/assets/images/designs/vintage.png"
                        className="card-img-top img-fluid"
                        alt="Invitación Vintage"
                        width={500}
                        height={300}
                      />
                      <div className="overlay-text">
                        <span>Ver Invitación</span>
                      </div>
                    </div>
                  </Link>
                </div>
                <div className="card-body text-center">
                  <h5 className="card-title title-color-primary">
                    Invitación Vintage
                  </h5>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>

      {/*Sección de Contacto*/}
      <section id="contact" className="py-6">
        <div className="container">
          <div className="text-center mb-5">
            <h2 className="section-title title-color-primary">Contáctanos</h2>
            <p className="section-subtitle fs-5">
              ¿Tienes preguntas? ¡Estamos aquí para ayudarte!
            </p>
          </div>
          <div className="text-center">
            <Link
              href="/presupuesto"
              target="_blank"
              className="btn btn-primary btn-lg btn-whatsapp"
            >
              <FontAwesomeIcon icon={faWhatsapp} className="mx-3" size="2x" />{" "}
              Contáctanos por WhatsApp
            </Link>
          </div>
        </div>
      </section>
    </Layout>
  );
}
