import Link from "next/link";
import Layout from "@/app/layout/layout-Empty";
import "@/styles/notfound.css";

export default function NotFound() {
  return (
    <Layout>
      <section className="loader-img bg-light z-index-0">
        <div className="overlay overlay-white z-index-1"></div>
      </section>
      <section className="mt-5 py-5 z-index-9999">
        <section className="error-container z-index-9999">
          <span className="four">
            <span className="screen-reader-text">4</span>
          </span>
          <span className="zero">
            <span className="screen-reader-text">0</span>
          </span>
          <span className="four">
            <span className="screen-reader-text">4</span>
          </span>
        </section>
        <p className="zoom-area z-index-9999">
          <b>La página que busca no se encuentra disponible.</b>
        </p>
        <div className="link-container z-index-9999">
          <Link href="/" className="btn btn-danger mx-3">
            Volver al inicio
          </Link>
        </div>
      </section>
    </Layout>
  );
}
