"use client";

import Link from "next/link";
import Layout from "@/app/layout/layout-Empty";
import Loader from "@/components/Loader";
import { useEffect, useState } from "react";
import { useRouter } from "next/navigation";
import "@/styles/custom-login.css";
import { api } from "@/libs/apiClient";
import { getSession } from "@/libs/session";

export default function Login() {
  const [isLoading, setIsLoading] = useState(false);
  const [error, setError] = useState(null);
  const router = useRouter();

  useEffect(() => {
    const fetchSession = async () => {
      try {
        const sessionGet = await getSession();
        if (sessionGet) {
          router.push("/intranet");
        }
      } catch (error) {
        console.error("Error al obtener la sesión", error);
        if (router.pathname !== "/login") {
          router.push("/login");
        }
      }
    };

    fetchSession();
  }, []);

  const validaUser = async (e) => {
    e.preventDefault();
    setIsLoading(true);
    const user = e.target.usuario.value;
    const pass = e.target.password.value;
    setError(null);

    try {
      const data = await api.post("/login", { user, pass });

      if (data) {
        const { userData, menuData } = data;

        const session = await api.post("/session/create", {
          userData,
          menuData,
        });
        
        if (session) {
          router.push("/intranet");
        }
      } else {
        setIsLoading(false);
        setError(data.message);
      }
    } catch (error) {
      setError(error.message);
    } finally {
    }
  };

  return (
    <Layout>
      {isLoading ? <Loader></Loader> : ""}
      <main className="content-main">
        <section className="header bg-light">
          <div className="overlay"></div>
          <div id="login" className="auto-container mt-5 mb-5">
            <div className="row justify-content-center">
              <div className="col-md-12">
                <form
                  onSubmit={validaUser}
                  name="LoginForm"
                  id="LoginForm"
                  method="POST"
                >
                  <div className="card card shadow-lg p-4 p-sm-5">
                    <div className="card-title">
                      <h5 className="card-title text-center fs-5 ">
                        Iniciar Sesión
                      </h5>
                    </div>
                    <div className="card-body ">
                      <div className="form-group mb-3">
                        <input
                          type="text"
                          className="form-control"
                          id="usuario"
                          name="usuario"
                          placeholder="usuario"
                        />
                      </div>
                      <div className="form-group mb-3">
                        <input
                          type="password"
                          className="form-control"
                          id="password"
                          name="password"
                          placeholder="contraseña"
                        />
                      </div>
                      {error && (
                        <span
                          style={{ display: "block" }}
                          className="invalid-feedback"
                          id="loginError"
                        >
                          <strong>{error}</strong>
                        </span>
                      )}
                    </div>
                    <div className="card-footer">
                      <div className="d-flex justify-content-between">
                        <Link href="/" className="btn btn-danger mx-3">
                          Pagina Principal
                        </Link>
                        <button
                          type="submit"
                          className="btn btn-success btn-login text-uppercase fw-bold float-right"
                        >
                          Ingresar
                        </button>
                      </div>
                    </div>
                  </div>
                </form>
              </div>
            </div>
          </div>
        </section>
      </main>
    </Layout>
  );
}
