"use client";

import Header from "@/components/Header";
import Footer from "@/components/Footer";
import PreLoader from "@/components/PreLoader";
import CustomThemes from "@/components/CustomThemes";
import { themes } from "@/libs/themes";
import React, { useEffect, useState } from "react";
import { getSession } from "@/libs/session";
import { useRouter } from "next/navigation";
import Loader from "@/components/Loader";

export default function LayoutIntranet({ children }) {
  const [loading, setLoading] = useState(true);

  const router = useRouter();

  useEffect(() => {
    require("bootstrap/dist/js/bootstrap.bundle.min.js");
  }, []);

  useEffect(() => {
    const fetchSession = async () => {
      try {
        const sessionGet = await getSession();

        if (!sessionGet && router.pathname !== "/login") {
          router.push("/login");
        } else {
          setLoading(false);
        }
      } catch (error) {
        console.error("Error al obtener la sesión", error);
        if (router.pathname !== "/login") {
          router.push("/login");
        }
      }
    };

    fetchSession();
  }, []);

  return (
    <>
      {loading ? (
        <Loader />
      ) : (
        <>
          <CustomThemes theme={themes.default} />
          <Header></Header>
          <main>
            <PreLoader>{children}</PreLoader>
          </main>
          <Footer></Footer>
        </>
      )}
    </>
  );
}
