import "@/styles/global.css";

export const metadata = {
  title: "MyBoda | Invitaciones de Matrimonio Digitales",
  description:
    "Invitaciones de matrimonio digitales personalizadas. Comparte tus invitaciones de boda de manera rápida y fácil.",
  keywords:
    "MyBoda, invitaciones digitales de matrimonio, bodas, invitaciones personalizadas, bodas digitales",
  authors: [{ name: "Jiempy SpA" }],
  metadataBase: new URL("https://myboda.cl"),
  icons: {
    icon: [
      {
        url: "/assets/images/icons/favicon-32x32.png",
        sizes: "32x32",
        type: "image/png",
      },
      {
        url: "/assets/images/icons/favicon-16x16.png",
        sizes: "16x16",
        type: "image/png",
      },
      {
        url: "/assets/images/icons/android-chrome-192x192.png",
        sizes: "192x192",
        type: "image/png",
      },
      {
        url: "/assets/images/icons/android-chrome-512x512.png",
        sizes: "512x512",
        type: "image/png",
      },
      { url: "/favicon.ico", type: "image/x-icon" },
    ],
    apple: "/assets/images/icons/apple-touch-icon.png",
  },
  openGraph: {
    title: "MyBoda | Invitaciones de Matrimonio Digitales",
    description: "MyBoda - Invitaciones digitales personalizadas para bodas.",
    url: "https://www.myboda.cl",
    type: "website",
    images: [
      {
        url: "/assets/images/icons/banner.png",
        width: 1200,
        height: 630,
        alt: "MyBoda Banner",
      },
    ],
  },
  manifest: "/assets/images/icons/site.webmanifest",
};

export const viewport = {
  themeColor: [
    { media: "(prefers-color-scheme: light)", color: "#ffffff" },
    { media: "(prefers-color-scheme: dark)", color: "#000000" },
  ],
};

export default function RootLayout({ children }) {
  return (
    <html lang="es">
      <body>
        {children}
        <div id="modal-root"></div>
      </body>
    </html>
  );
}
