"use client";

import { useEffect, useState } from "react";
import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
  faAnglesRight,
  faCancel,
  faPencil,
  faSave,
} from "@fortawesome/free-solid-svg-icons";
import Loader from "@/components/Loader";

export default function Invitados() {
  const [editando, setEditando] = useState(false);
  const [formData, setFormData] = useState(undefined);
  const [template, setTemplate] = useState(undefined);
  const [rol, setRol] = useState(undefined);
  const [errorMail, setErrorMail] = useState(null);
  const [loading, setLoading] = useState(null);
  const [resultOk, setResultOk] = useState(null);
  const [resultErr, setResultErr] = useState(null);

  useEffect(() => {
    setFormData({
      id: datos.id,
      nombres: datos.nombres,
      usuario: datos.usuario,
      email: datos.email,
      telefono: datos.telefono,
      id_rol: datos.id_rol,
      id_template: datos.id_template,
      estado: datos.estado,
    });

    setTemplate({});

    setRol({});
  }, [datos]);

  const habilitarEdicion = (estado) => {
    setEditando(estado);
  };

  const handleChange = (e) => {
    const { name, value } = e.target;

    setFormData((prevFormData) => ({
      ...prevFormData,
      [name]: value,
    }));
  };

  const handleSubmit = async () => {
    let validaForm = false;

    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(formData.email)) {
      setErrorMail("Ingresar un Email válido.");
      validaForm = false;
    } else {
      setErrorMail(null);
    }

    if (!validaForm) return;

    setLoading(true);
    try {
      const data = await api.put("/usuarios/updateUsuario", {
        id: formData.id,
        nombres: formData.nombres,
        usuario: formData.usuario,
        email: formData.email,
        telefono: formData.telefono,
        id_rol: formData.id_rol,
        id_template: formData.id_template,
        estado: formData.estado,
      });

      if (data) {
        setResultOk(data.message);

        const resFormData = await getFormData();

        const menuData = resFormData.menuData;
        const userData = data.userData;

        const formData = await api.post("/formData/create", {
          userData,
          menuData,
        });
      } else {
        setResultErr(data.message);
      }
    } catch (error) {
      setResultErr(error.message);
    } finally {
      setLoading(false);
      setEditando(false);
    }
  };

  return (
    <>
      {formData === undefined || loading ? (
        <Loader></Loader>
      ) : (
        <section id="usuarios" className="mt-3">
          <div className="card">
            <div className="card-header p-0 m-0 " id="head-usuarios">
              <button
                className="btn p-2 m-0 w-100 cursor-pointer d-flex justify-content-between align-items-center collapsed"
                data-bs-toggle="collapse"
                data-bs-target="#collapse-usuarios"
                aria-expanded="false"
                aria-controls="collapse-usuarios"
              >
                <h4 className="fw-bold p-0 m-0">Usuarios</h4>
                <FontAwesomeIcon
                  className="accordion-icon"
                  icon={faAnglesRight}
                />
              </button>
            </div>
            <div
              id="collapse-usuarios"
              className="collapse"
              aria-labelledby="head-usuarios"
              data-bs-parent="#accordion"
            >
              <div className="card-body">
                {resultOk && showAlert && (
                  <div className="alert alert-success" role="alert">
                    {resultOk}
                    <button
                      type="button"
                      className="close"
                      data-dismiss="alert"
                      aria-label="Close"
                      onClick={() => setShowAlert(false)}
                    >
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                )}
                {resultErr && showAlert && (
                  <div className="alert alert-danger" role="alert">
                    {resultErr}
                    <button
                      type="button"
                      className="close"
                      data-dismiss="alert"
                      aria-label="Close"
                      onClick={() => setShowAlert(false)}
                    >
                      <span aria-hidden="true">&times;</span>
                    </button>
                  </div>
                )}
                <div className="row col-md-12">
                  <div className="col-md-3">
                    <label className="fw-bold">Usuario</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="usuario"
                        id="usuario"
                        value={formData.usuario ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Nombres</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="nombres"
                        id="nombres"
                        value={formData.nombres ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Telefono</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="telefono"
                        id="telefono"
                        value={formData.telefono ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Email</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="email"
                        id="email"
                        value={formData.email ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Diseño</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="id_template"
                        id="id_template"
                        value={formData.id_template ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Rol</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="id_rol"
                        id="id_rol"
                        value={formData.id_rol ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                  <div className="col-md-3">
                    <label className="fw-bold">Estado</label>
                    <div className="form-group">
                      <input
                        type="text"
                        className="form-control"
                        name="estado"
                        id="estado"
                        value={formData.estado ?? ""}
                        onChange={handleChange}
                        disabled={!editando}
                      />
                    </div>
                  </div>
                </div>
              </div>
              {errorMail && (
                <div className="col-md-3">
                  <span
                    style={{ display: "block" }}
                    className="invalid-feedback mb-2"
                  >
                    <strong>{errorMail}</strong>
                  </span>
                </div>
              )}
              <div className="card-footer">
                <div className="form-group py-3">
                  {!editando ? (
                    <button
                      className="btn btn-primary"
                      type="button"
                      onClick={() => habilitarEdicion(true)}
                    >
                      <FontAwesomeIcon icon={faPencil}></FontAwesomeIcon>{" "}
                      Modificar
                    </button>
                  ) : (
                    <>
                      <button
                        className="btn btn-success"
                        type="button"
                        onClick={handleSubmit}
                      >
                        <FontAwesomeIcon icon={faSave}></FontAwesomeIcon>{" "}
                        Guardar
                      </button>
                      <button
                        className="btn btn-info mx-2"
                        type="button"
                        onClick={() => habilitarEdicion(false)}
                      >
                        <FontAwesomeIcon icon={faCancel}></FontAwesomeIcon>{" "}
                        Cancelar
                      </button>
                    </>
                  )}
                </div>
              </div>
            </div>
          </div>
        </section>
      )}
    </>
  );
}
