"use client";

import { useEffect, useState } from "react";
import Layout from "@/app/layout/layout-intranet";
import { api } from "@/libs/apiClient";

export default function Dashboard() {
  const [novios, setNovios] = useState([]);
  const [configs, setConfigs] = useState([]);
  const [cronograma, setCronograma] = useState([]);
  const [gift, setGift] = useState([]);
  const [history, setHistory] = useState([]);
  const [gallery, setGallery] = useState([]);

  useEffect(() => {
    const cargarDatos = async () => {
      try {
        const [noviosData, configsData, cronogramaData, giftData, historyData, galleryData] =
          await Promise.all([
            api.get("/novios"),
            api.get("/configs"),
            api.get("/cronograma"),
            api.get("/gift"),
            api.get("/history"),
            api.get("/gallery"),
          ]);

        setNovios(noviosData);
        setConfigs(configsData);
        setCronograma(cronogramaData);
        setGift(giftData);
        setHistory(historyData);
        setGallery(galleryData);
      } catch (error) {
        console.error("Error al cargar datos:", error.message);
      }
    };

    cargarDatos();
  }, []);

  return (
    <Layout>
      <div className="container mt-5">
        <h1 className="mb-4">Panel de Administración</h1>

        {/* Novios */}
        <section className="mb-5">
          <h2>Novios</h2>
          <table className="table table-bordered">
            <thead>
              <tr>
                <th>Nombre Novio</th>
                <th>Nombre Novia</th>
                <th>Fecha Evento</th>
                {/* Agrega más columnas según sea necesario */}
              </tr>
            </thead>
            <tbody>
              {novios.map((novio) => (
                <tr key={novio.id}>
                  <td>{novio.nombre_novio}</td>
                  <td>{novio.nombre_novia}</td>
                  <td>{novio.fecha_evento}</td>
                  {/* Agrega más celdas según sea necesario */}
                </tr>
              ))}
            </tbody>
          </table>
        </section>

        {/* Configs */}
        <section className="mb-5">
          <h2>Configuraciones</h2>
          <table className="table table-bordered">
            <thead>
              <tr>
                <th>Nombre</th>
                <th>Descripción</th>
                <th>URL</th>
                {/* Agrega más columnas según sea necesario */}
              </tr>
            </thead>
            <tbody>
              {configs.map((config) => (
                <tr key={config.id}>
                  <td>{config.nombre}</td>
                  <td>{config.descripcion}</td>
                  <td>{config.url}</td>
                  {/* Agrega más celdas según sea necesario */}
                </tr>
              ))}
            </tbody>
          </table>
        </section>

        {/* Repite secciones similares para cronograma, gift, history y gallery */}
      </div>
    </Layout>
  );
}
