"use client";

import { useEffect } from "react";
import Layout from "@/app/layout/layout-Empty";
import Link from "next/link";

export default function Privacy() {
  useEffect(() => {
    require("bootstrap/dist/js/bootstrap.bundle.min.js");
  }, []);

  return (
    <Layout>
      {/*header Section */}
      <section id="header" className="header bg-light">
        <div className="overlay"></div>
      </section>
      {/*Privacity Section */}
      <section className="" id="privacy">
        <div className="container">
          <div className="row h-100">
            <div className="col-lg-7 mt-7">
              <h4 className="lh-lg fw-bold text-uppercase mt-4">
                Condiciones del Servicio de MyBoda
              </h4>
            </div>
            <div className="row align-items-justify mt-4">
              <p>
                Bienvenido a MyBoda. Al utilizar nuestros servicios, usted
                acepta cumplir con las siguientes condiciones:
              </p>
              <p className="fw-bold">1. Uso del servicio</p>
              <p>
                El servicio está destinado únicamente para comunicación y
                gestión interna de documentos y procesos relacionados con la
                operación de la empresa de transportes. Queda prohibido el uso
                con fines ilegales o de marketing no autorizado.
              </p>
              <p className="fw-bold">2. Privacidad y datos</p>
              <p>
                Respetamos la privacidad de nuestros usuarios. Los datos
                recolectados serán usados únicamente para los fines indicados en
                nuestra{" "}
                <Link href="/privacy" className="fw-bold text-dark">
                  Política de Privacidad
                </Link>
                .
              </p>
              <p className="fw-bold">3. Responsabilidades del usuario</p>
              <p>
                Proporcionar información veraz y actualizada. <br></br>
                No compartir acceso a terceros no autorizados. <br></br>
                Cumplir con las indicaciones del sistema para la correcta
                gestión de documentos o comunicaciones. <br></br>
              </p>
              <p className="fw-bold">4. Limitación de responsabilidad</p>
              <p>
                MyBoda no se hace responsable por retrasos, errores o
                pérdidas de información derivados del uso del servicio fuera de
                las condiciones aquí indicadas.
              </p>
              <p className="fw-bold">5. Cambios en las condiciones</p>
              <p>
                Nos reservamos el derecho de actualizar estas condiciones en
                cualquier momento. Las modificaciones serán publicadas en esta
                página.
              </p>
              <p className="fw-bold">6. Contacto</p>
              <p>
                Para dudas o consultas sobre estas condiciones, puede
                contactarnos en:{" "}
                <a
                  href="mailto:contacto@myboda.cl"
                  className="fw-bold text-dark"
                >
                  contacto@myboda.cl
                </a>
              </p>
              <p className="fw-bold">Fecha de última actualización: 01/08/2024</p>
            </div>
          </div>
        </div>
      </section>
    </Layout>
  );
}
