"use client";

import Layout from "@/app/layout/layout-intranet";
import React, { useEffect, useState, useRef } from "react";
import { useRouter } from "next/navigation";
import Loader from "@/components/Loader";

export default function Administrador() {
  const [session, setSession] = useState(undefined);
  const [data, setData] = useState([]);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    const cargarDatos = async () => {
      try {
        const response = await api.get("/usuarios/");

        if (response) {
          setData(response);
          setLoading(false);
        }
      } catch (error) {
        console.error("Error al cargar datos:", error.message);
      }
    };

    cargarDatos();
  }, []);

  return (
    <Layout>
      {loading && !data ? (
        <Loader/>
      ) : (
        <h1 className="mt-6">Administrador</h1>
      )}
    </Layout>
  );
}
