import js from "@eslint/js";
import globals from "globals";
import pluginReact from "eslint-plugin-react";
import nextConfig from "eslint-config-next";
import { defineConfig } from "eslint/config";

export default defineConfig([
  {
    files: ["**/*.{js,jsx,ts,tsx}"],
    languageOptions: {
      globals: {
        ...globals.browser,
        ...globals.node,
      },
    },
    plugins: {
      js,
      react: pluginReact,
    },
    rules: {
      // Puedes agregar reglas personalizadas aquí
    },
  },
  ...nextConfig.configs["core-web-vitals"], // <- Aquí estás usando la configuración oficial de Next.js
]);
